rule win_netsupportmanager_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.netsupportmanager_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netsupportmanager_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b4530 83c62c 3bf0 7516 8b4538 83c004 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4530               | mov                 eax, dword ptr [ebp + 0x30]
            //   83c62c               | add                 esi, 0x2c
            //   3bf0                 | cmp                 esi, eax
            //   7516                 | jne                 0x18
            //   8b4538               | mov                 eax, dword ptr [ebp + 0x38]
            //   83c004               | add                 eax, 4

        $sequence_1 = { ffd7 68???????? 56 894344 ffd7 8b7508 89431c }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   68????????           |                     
            //   56                   | push                esi
            //   894344               | mov                 dword ptr [ebx + 0x44], eax
            //   ffd7                 | call                edi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   89431c               | mov                 dword ptr [ebx + 0x1c], eax

        $sequence_2 = { e9???????? 8d8d4cffffff e9???????? 8d8dacfeffff e9???????? 8d8d6cffffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]
            //   e9????????           |                     
            //   8d8dacfeffff         | lea                 ecx, [ebp - 0x154]
            //   e9????????           |                     
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   e9????????           |                     

        $sequence_3 = { e8???????? 83f82a 7520 ba???????? 85d2 7417 6877270000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83f82a               | cmp                 eax, 0x2a
            //   7520                 | jne                 0x22
            //   ba????????           |                     
            //   85d2                 | test                edx, edx
            //   7417                 | je                  0x19
            //   6877270000           | push                0x2777

        $sequence_4 = { ffd7 8b4620 50 ff15???????? 8b4e24 5f 66c741080000 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4e24               | mov                 ecx, dword ptr [esi + 0x24]
            //   5f                   | pop                 edi
            //   66c741080000         | mov                 word ptr [ecx + 8], 0

        $sequence_5 = { 8dbe88000000 c745fc06000000 8b07 85c0 7403 50 ffd3 }
            // n = 7, score = 100
            //   8dbe88000000         | lea                 edi, [esi + 0x88]
            //   c745fc06000000       | mov                 dword ptr [ebp - 4], 6
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_6 = { ff15???????? 5f 33c0 5e c3 68???????? 56 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_7 = { e8???????? 8b3d???????? 83c418 68???????? 56 ffd7 3bc3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b3d????????         |                     
            //   83c418               | add                 esp, 0x18
            //   68????????           |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   3bc3                 | cmp                 eax, ebx

        $sequence_8 = { ff4020 8b7604 8b460c 85c0 740a 8b450c 85c0 }
            // n = 7, score = 100
            //   ff4020               | inc                 dword ptr [eax + 0x20]
            //   8b7604               | mov                 esi, dword ptr [esi + 4]
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85c0                 | test                eax, eax

        $sequence_9 = { ff5254 83f8ff 0f8517020000 8b4514 8b16 50 57 }
            // n = 7, score = 100
            //   ff5254               | call                dword ptr [edx + 0x54]
            //   83f8ff               | cmp                 eax, -1
            //   0f8517020000         | jne                 0x21d
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   50                   | push                eax
            //   57                   | push                edi

    condition:
        7 of them and filesize < 4734976
}