rule win_nettraveler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nettraveler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nettraveler"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 50 68???????? ff7510 ff15???????? ff7510 e8???????? }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   50                   | push                eax
            //   68????????           |                     
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff15????????         |                     
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     

        $sequence_1 = { 5e 5d 83c440 c3 56 e8???????? e8???????? }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   83c440               | add                 esp, 0x40
            //   c3                   | ret                 
            //   56                   | push                esi
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 0bd1 0355b4 8dbc17aac7b6e9 8bd0 8bcf }
            // n = 5, score = 100
            //   0bd1                 | or                  edx, ecx
            //   0355b4               | add                 edx, dword ptr [ebp - 0x4c]
            //   8dbc17aac7b6e9       | lea                 edi, [edi + edx - 0x16493856]
            //   8bd0                 | mov                 edx, eax
            //   8bcf                 | mov                 ecx, edi

        $sequence_3 = { aa 8bca 33c0 8dbdddefffff 80a5dcf3ffff00 f3ab }
            // n = 6, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8bca                 | mov                 ecx, edx
            //   33c0                 | xor                 eax, eax
            //   8dbdddefffff         | lea                 edi, [ebp - 0x1023]
            //   80a5dcf3ffff00       | and                 byte ptr [ebp - 0xc24], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_4 = { ff37 56 ff15???????? 53 ff37 56 ff15???????? }
            // n = 7, score = 100
            //   ff37                 | push                dword ptr [edi]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   ff37                 | push                dword ptr [edi]
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_5 = { ffd6 bd???????? 8d442418 55 68???????? 50 ffd7 }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   bd????????           |                     
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   55                   | push                ebp
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_6 = { 53 6a03 53 53 ff75c0 ff75b8 ff7510 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff75c0               | push                dword ptr [ebp - 0x40]
            //   ff75b8               | push                dword ptr [ebp - 0x48]
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_7 = { ff7508 ffd6 53 8d8590f6ffff 53 50 }
            // n = 6, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd6                 | call                esi
            //   53                   | push                ebx
            //   8d8590f6ffff         | lea                 eax, [ebp - 0x970]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_8 = { 8db4850cffffff 8b4508 33d2 0fb6803c910010 8bf8 }
            // n = 5, score = 100
            //   8db4850cffffff       | lea                 esi, [ebp + eax*4 - 0xf4]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   33d2                 | xor                 edx, edx
            //   0fb6803c910010       | movzx               eax, byte ptr [eax + 0x1000913c]
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { ff75fc ff15???????? 85c0 7417 8d85f4fdffff 56 }
            // n = 6, score = 100
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7417                 | je                  0x19
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   56                   | push                esi

    condition:
        7 of them and filesize < 106496
}