rule win_neutrino_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.neutrino."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neutrino"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? c1e010 50 ff15???????? }
            // n = 4, score = 2300
            //   ff15????????         |                     
            //   c1e010               | shl                 eax, 0x10
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 50 6a0b 6a07 e8???????? }
            // n = 4, score = 1600
            //   50                   | push                eax
            //   6a0b                 | push                0xb
            //   6a07                 | push                7
            //   e8????????           |                     

        $sequence_2 = { 50 6a05 6a03 e8???????? }
            // n = 4, score = 1600
            //   50                   | push                eax
            //   6a05                 | push                5
            //   6a03                 | push                3
            //   e8????????           |                     

        $sequence_3 = { 0404 010404 0202 020402 }
            // n = 4, score = 1500
            //   0404                 | add                 al, 4
            //   010404               | add                 dword ptr [esp + eax], eax
            //   0202                 | add                 al, byte ptr [edx]
            //   020402               | add                 al, byte ptr [edx + eax]

        $sequence_4 = { 50 6a00 6a00 ff15???????? 8b4dd8 }
            // n = 5, score = 1500
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]

        $sequence_5 = { 010404 0202 020402 0404 0404 0404 }
            // n = 6, score = 1500
            //   010404               | add                 dword ptr [esp + eax], eax
            //   0202                 | add                 al, byte ptr [edx]
            //   020402               | add                 al, byte ptr [edx + eax]
            //   0404                 | add                 al, 4
            //   0404                 | add                 al, 4
            //   0404                 | add                 al, 4

        $sequence_6 = { 8b4d0c 894dfc 8b55f4 0fbe02 85c0 7447 8b4df4 }
            // n = 7, score = 1500
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   0fbe02               | movsx               eax, byte ptr [edx]
            //   85c0                 | test                eax, eax
            //   7447                 | je                  0x49
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_7 = { e9???????? 6a01 ff15???????? 85c0 }
            // n = 4, score = 1500
            //   e9????????           |                     
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 83c404 0fb6d0 83fa01 7531 8b45fc 83c001 8945fc }
            // n = 7, score = 1500
            //   83c404               | add                 esp, 4
            //   0fb6d0               | movzx               edx, al
            //   83fa01               | cmp                 edx, 1
            //   7531                 | jne                 0x33
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c001               | add                 eax, 1
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_9 = { 51 8b5508 52 ff15???????? 83f8ff 7504 32c0 }
            // n = 7, score = 1500
            //   51                   | push                ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al

        $sequence_10 = { 83c201 8955f4 ebaf 8b45f4 a3???????? 8b45f8 2b45f4 }
            // n = 7, score = 1500
            //   83c201               | add                 edx, 1
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   ebaf                 | jmp                 0xffffffb1
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   a3????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   2b45f4               | sub                 eax, dword ptr [ebp - 0xc]

        $sequence_11 = { 894d08 0fb6550c 83fa01 7509 8b4508 83c001 894508 }
            // n = 7, score = 1500
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   0fb6550c             | movzx               edx, byte ptr [ebp + 0xc]
            //   83fa01               | cmp                 edx, 1
            //   7509                 | jne                 0xb
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c001               | add                 eax, 1
            //   894508               | mov                 dword ptr [ebp + 8], eax

        $sequence_12 = { 6a00 ff15???????? 6880000000 ff15???????? }
            // n = 4, score = 1500
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6880000000           | push                0x80
            //   ff15????????         |                     

        $sequence_13 = { 0fbe02 8b4df8 0fbe11 3bc2 740b 8b45fc 83c001 }
            // n = 7, score = 1500
            //   0fbe02               | movsx               eax, byte ptr [edx]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   0fbe11               | movsx               edx, byte ptr [ecx]
            //   3bc2                 | cmp                 eax, edx
            //   740b                 | je                  0xd
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c001               | add                 eax, 1

        $sequence_14 = { 8b55fc 0fbe02 85c0 750f 8b4d0c 894dfc 8b55f4 }
            // n = 7, score = 1500
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0fbe02               | movsx               eax, byte ptr [edx]
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_15 = { 0f8440feffff 80fa05 7354 8b3b 0fb6f2 6a05 }
            // n = 6, score = 1300
            //   0f8440feffff         | je                  0xfffffe46
            //   80fa05               | cmp                 dl, 5
            //   7354                 | jae                 0x56
            //   8b3b                 | mov                 edi, dword ptr [ebx]
            //   0fb6f2               | movzx               esi, dl
            //   6a05                 | push                5

        $sequence_16 = { f645fe20 740d 814a1804010000 8a03 884210 43 8ac3 }
            // n = 7, score = 1300
            //   f645fe20             | test                byte ptr [ebp - 2], 0x20
            //   740d                 | je                  0xf
            //   814a1804010000       | or                  dword ptr [edx + 0x18], 0x104
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   884210               | mov                 byte ptr [edx + 0x10], al
            //   43                   | inc                 ebx
            //   8ac3                 | mov                 al, bl

        $sequence_17 = { 32c0 c645ff00 895dec c645fb00 f3aa c645f810 }
            // n = 6, score = 1300
            //   32c0                 | xor                 al, al
            //   c645ff00             | mov                 byte ptr [ebp - 1], 0
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   c645fb00             | mov                 byte ptr [ebp - 5], 0
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   c645f810             | mov                 byte ptr [ebp - 8], 0x10

        $sequence_18 = { 807dfd05 eb12 807dfd04 c645fc03 0f879a000000 807dfd01 }
            // n = 6, score = 1300
            //   807dfd05             | cmp                 byte ptr [ebp - 3], 5
            //   eb12                 | jmp                 0x14
            //   807dfd04             | cmp                 byte ptr [ebp - 3], 4
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   0f879a000000         | ja                  0xa0
            //   807dfd01             | cmp                 byte ptr [ebp - 3], 1

        $sequence_19 = { 0f879a000000 807dfd01 0f8597000000 e9???????? 2d8c000000 747e 48 }
            // n = 7, score = 1300
            //   0f879a000000         | ja                  0xa0
            //   807dfd01             | cmp                 byte ptr [ebp - 3], 1
            //   0f8597000000         | jne                 0x9d
            //   e9????????           |                     
            //   2d8c000000           | sub                 eax, 0x8c
            //   747e                 | je                  0x80
            //   48                   | dec                 eax

        $sequence_20 = { 8b03 894210 83c304 eb13 f645fe20 740d 814a1804010000 }
            // n = 7, score = 1300
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   894210               | mov                 dword ptr [edx + 0x10], eax
            //   83c304               | add                 ebx, 4
            //   eb13                 | jmp                 0x15
            //   f645fe20             | test                byte ptr [ebp - 2], 0x20
            //   740d                 | je                  0xf
            //   814a1804010000       | or                  dword ptr [edx + 0x18], 0x104

        $sequence_21 = { c3 8b4804 890e ff4808 897004 751e }
            // n = 6, score = 1300
            //   c3                   | ret                 
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   890e                 | mov                 dword ptr [esi], ecx
            //   ff4808               | dec                 dword ptr [eax + 8]
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   751e                 | jne                 0x20

        $sequence_22 = { 83c404 85c0 0f95c2 0fb6c2 }
            // n = 4, score = 1200
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f95c2               | setne               dl
            //   0fb6c2               | movzx               eax, dl

        $sequence_23 = { 55 8bec 81ecf80f0000 837d0800 }
            // n = 4, score = 1100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ecf80f0000         | sub                 esp, 0xff8
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0

        $sequence_24 = { 8d85b8feffff 50 68???????? ff15???????? 8945fc }
            // n = 5, score = 1100
            //   8d85b8feffff         | lea                 eax, [ebp - 0x148]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_25 = { 83c40c 6804010000 8d85f8fdffff 50 }
            // n = 4, score = 1000
            //   83c40c               | add                 esp, 0xc
            //   6804010000           | push                0x104
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax

        $sequence_26 = { ff750c ff7508 ff15???????? 83f8ff 0f95c0 }
            // n = 5, score = 800
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f95c0               | setne               al

        $sequence_27 = { 7522 be???????? ff15???????? 57 8906 ff15???????? 83c604 }
            // n = 7, score = 800
            //   7522                 | jne                 0x24
            //   be????????           |                     
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8906                 | mov                 dword ptr [esi], eax
            //   ff15????????         |                     
            //   83c604               | add                 esi, 4

        $sequence_28 = { 7507 68???????? eb05 68???????? 50 ff510c }
            // n = 6, score = 800
            //   7507                 | jne                 9
            //   68????????           |                     
            //   eb05                 | jmp                 7
            //   68????????           |                     
            //   50                   | push                eax
            //   ff510c               | call                dword ptr [ecx + 0xc]

        $sequence_29 = { 50 ff15???????? 837dfc00 0f95c0 c9 c3 }
            // n = 6, score = 800
            //   50                   | push                eax
            //   ff15????????         |                     
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   0f95c0               | setne               al
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_30 = { 7412 68???????? 50 ff15???????? f7d8 1bc0 40 }
            // n = 7, score = 800
            //   7412                 | je                  0x14
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   40                   | inc                 eax

        $sequence_31 = { 50 ff15???????? 6a40 ff75f0 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a40                 | push                0x40
            //   ff75f0               | push                dword ptr [ebp - 0x10]

    condition:
        7 of them and filesize < 507904
}