rule win_nevada_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nevada."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nevada"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4889ea e8???????? 0f0b 4c8d0515c10200 ba00100000 4889e9 e8???????? }
            // n = 7, score = 100
            //   4889ea               | mov                 edx, esi
            //   e8????????           |                     
            //   0f0b                 | dec                 ebp
            //   4c8d0515c10200       | mov                 eax, esp
            //   ba00100000           | dec                 eax
            //   4889e9               | mov                 edx, ebx
            //   e8????????           |                     

        $sequence_1 = { 4d89f8 664585e4 0f8597feffff e9???????? 4981fe01010000 0f834a010000 0f57c0 }
            // n = 7, score = 100
            //   4d89f8               | mov                 dword ptr [edi + 0x18], eax
            //   664585e4             | dec                 ecx
            //   0f8597feffff         | mov                 dword ptr [edi + 0x20], edx
            //   e9????????           |                     
            //   4981fe01010000       | dec                 eax
            //   0f834a010000         | mov                 ecx, dword ptr [esp + 0x60]
            //   0f57c0               | dec                 ecx

        $sequence_2 = { e8???????? 4c8da42450020000 4c89e1 4889fa 4d89f8 e8???????? 488db42478020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8da42450020000     | mov                 eax, dword ptr [ebp + 0x1a0]
            //   4c89e1               | dec                 eax
            //   4889fa               | lea                 ecx, [eax + eax*2]
            //   4d89f8               | dec                 eax
            //   e8????????           |                     
            //   488db42478020000     | lea                 ecx, [ebp + 0xa0]

        $sequence_3 = { 4839ce 74c4 803ea0 72bf eb3e 4839ce 4889d7 }
            // n = 7, score = 100
            //   4839ce               | add                 esp, 0x20
            //   74c4                 | pop                 ebx
            //   803ea0               | pop                 ebp
            //   72bf                 | pop                 edi
            //   eb3e                 | dec                 eax
            //   4839ce               | cmp                 dword ptr [esi + 8], edi
            //   4889d7               | jne                 0x252

        $sequence_4 = { 438a443cff 3c2f 7438 3c5c 7434 e9???????? 41813f5c5c3f5c }
            // n = 7, score = 100
            //   438a443cff           | mov                 ecx, 2
            //   3c2f                 | mov                 esi, eax
            //   7438                 | test                eax, eax
            //   3c5c                 | je                  0x95e
            //   7434                 | inc                 ecx
            //   e9????????           |                     
            //   41813f5c5c3f5c       | mov                 eax, 0x10

        $sequence_5 = { 415f c3 4c8d642430 488dac24b0000000 eb26 488b8424c0000000 48035c2420 }
            // n = 7, score = 100
            //   415f                 | inc                 ecx
            //   c3                   | pop                 esp
            //   4c8d642430           | inc                 ecx
            //   488dac24b0000000     | pop                 esi
            //   eb26                 | inc                 ecx
            //   488b8424c0000000     | pop                 edi
            //   48035c2420           | ret                 

        $sequence_6 = { 4080fd02 0f8510010000 488d6901 4c39c5 0f83fe000000 803c2abf b301 }
            // n = 7, score = 100
            //   4080fd02             | cmp                 al, 3
            //   0f8510010000         | je                  0x874
            //   488d6901             | inc                 ecx
            //   4c39c5               | cmp                 ah, al
            //   0f83fe000000         | ja                  0x874
            //   803c2abf             | dec                 eax
            //   b301                 | lea                 ecx, [edi + 0x10]

        $sequence_7 = { 0f821affffff 8b442428 4189442434 8a442427 4188442438 31ed e9???????? }
            // n = 7, score = 100
            //   0f821affffff         | mov                 esi, dword ptr [ebp + 0x290]
            //   8b442428             | dec                 ecx
            //   4189442434           | mov                 ebp, esi
            //   8a442427             | dec                 ebp
            //   4188442438           | mov                 esi, dword ptr [esp]
            //   31ed                 | dec                 ebp
            //   e9????????           |                     

        $sequence_8 = { 48837f1000 0f859c010000 4d89c4 4989d7 488d4710 488945e8 48c74710ffffffff }
            // n = 7, score = 100
            //   48837f1000           | dec                 esp
            //   0f859c010000         | lea                 eax, [0x3a988]
            //   4d89c4               | dec                 eax
            //   4989d7               | add                 esp, 0xa8
            //   488d4710             | pop                 ebx
            //   488945e8             | pop                 edi
            //   48c74710ffffffff     | pop                 esi

        $sequence_9 = { 4c8d3559910200 4c39c9 7317 0f1f840000000000 4885db 740a 803c0b45 }
            // n = 7, score = 100
            //   4c8d3559910200       | je                  0x92e
            //   4c39c9               | inc                 edx
            //   7317                 | movzx               esi, byte ptr [eax + eax]
            //   0f1f840000000000     | add                 edx, esi
            //   4885db               | cmp                 edx, ecx
            //   740a                 | dec                 esp
            //   803c0b45             | lea                 eax, [0x22eb6]

    condition:
        7 of them and filesize < 1063936
}