rule win_newbounce_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.newbounce."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newbounce"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e00f 7e05 2bf0 83c610 }
            // n = 4, score = 300
            //   83e00f               | and                 eax, 0xf
            //   7e05                 | jle                 7
            //   2bf0                 | sub                 esi, eax
            //   83c610               | add                 esi, 0x10

        $sequence_1 = { 7c11 8a03 4b8b8cf8a0b40600 48ffc3 }
            // n = 4, score = 200
            //   7c11                 | lea                 ecx, [esp + 0x68]
            //   8a03                 | dec                 eax
            //   4b8b8cf8a0b40600     | mov                 ecx, dword ptr [ecx]
            //   48ffc3               | dec                 eax

        $sequence_2 = { 7c2f 803b39 7f2a 488d4c2420 }
            // n = 4, score = 200
            //   7c2f                 | jl                  0xe
            //   803b39               | dec                 eax
            //   7f2a                 | lea                 edx, [0x2d0ba]
            //   488d4c2420           | dec                 eax

        $sequence_3 = { 7c07 488d4c2438 eb0a 4889442430 488d4c2430 488b09 483b8e78020000 }
            // n = 7, score = 200
            //   7c07                 | jl                  9
            //   488d4c2438           | dec                 eax
            //   eb0a                 | lea                 ecx, [esp + 0x38]
            //   4889442430           | jmp                 0xc
            //   488d4c2430           | dec                 eax
            //   488b09               | mov                 dword ptr [esp + 0x30], eax
            //   483b8e78020000       | dec                 eax

        $sequence_4 = { 7c0c 488d15bad00200 e9???????? 488d1566d00200 }
            // n = 4, score = 200
            //   7c0c                 | jmp                 0x11
            //   488d15bad00200       | dec                 eax
            //   e9????????           |                     
            //   488d1566d00200       | mov                 dword ptr [esp + 0x68], eax

        $sequence_5 = { 7c8d 4863c8 498bd6 85c0 }
            // n = 4, score = 200
            //   7c8d                 | jg                  0x2f
            //   4863c8               | dec                 eax
            //   498bd6               | lea                 ecx, [esp + 0x20]
            //   85c0                 | jl                  0x31

        $sequence_6 = { 7c4b 4c8bc6 e8???????? 48017748 }
            // n = 4, score = 200
            //   7c4b                 | mov                 al, byte ptr [ebx]
            //   4c8bc6               | dec                 ebx
            //   e8????????           |                     
            //   48017748             | mov                 ecx, dword ptr [eax + edi*8 + 0x6b4a0]

        $sequence_7 = { 7c07 488d4c2460 eb0a 4889442468 }
            // n = 4, score = 200
            //   7c07                 | lea                 ecx, [esp + 0x30]
            //   488d4c2460           | dec                 eax
            //   eb0a                 | mov                 ecx, dword ptr [ecx]
            //   4889442468           | dec                 eax

        $sequence_8 = { 81ec68010000 a1???????? 33c4 89842464010000 56 57 8bf1 }
            // n = 7, score = 100
            //   81ec68010000         | xor                 eax, ebp
            //   a1????????           |                     
            //   33c4                 | mov                 dword ptr [ebp - 0x14], eax
            //   89842464010000       | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf1                 | sub                 esp, 0x350

        $sequence_9 = { 81ec20020000 a1???????? 33c4 89842418020000 56 }
            // n = 5, score = 100
            //   81ec20020000         | dec                 esp
            //   a1????????           |                     
            //   33c4                 | mov                 eax, esi
            //   89842418020000       | dec                 eax
            //   56                   | add                 dword ptr [edi + 0x48], esi

        $sequence_10 = { 81ec50030000 a1???????? 33c5 8945ec 53 }
            // n = 5, score = 100
            //   81ec50030000         | dec                 esp
            //   a1????????           |                     
            //   33c5                 | lea                 eax, [ebp + ecx*4 - 2]
            //   8945ec               | inc                 ecx
            //   53                   | movzx               eax, word ptr [eax]

        $sequence_11 = { 81ec28010000 a1???????? 33c5 8945fc 8b4610 }
            // n = 5, score = 100
            //   81ec28010000         | dec                 eax
            //   a1????????           |                     
            //   33c5                 | mov                 edx, dword ptr [edi + 0x48]
            //   8945fc               | jne                 0x1a
            //   8b4610               | jl                  0xffffff8f

        $sequence_12 = { 81ec64060000 a1???????? 33c4 89842460060000 53 }
            // n = 5, score = 100
            //   81ec64060000         | xor                 eax, ebp
            //   a1????????           |                     
            //   33c4                 | mov                 dword ptr [ebp - 4], eax
            //   89842460060000       | push                esi
            //   53                   | push                edi

        $sequence_13 = { 81ec8c010000 56 a1???????? 33c5 }
            // n = 4, score = 100
            //   81ec8c010000         | lea                 eax, [ebp - 0x310]
            //   56                   | push                0
            //   a1????????           |                     
            //   33c5                 | sub                 esp, 0x358

        $sequence_14 = { 81ec58030000 a1???????? 33c4 89842450030000 }
            // n = 4, score = 100
            //   81ec58030000         | push                esi
            //   a1????????           |                     
            //   33c4                 | sub                 esp, 0x220
            //   89842450030000       | xor                 eax, esp

    condition:
        7 of them and filesize < 8637440
}