rule win_newcore_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.newcore_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newcore_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b883c200000 52 51 c744241000000000 ff15???????? f7d8 1bc0 }
            // n = 7, score = 100
            //   8b883c200000         | mov                 ecx, dword ptr [eax + 0x203c]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   ff15????????         |                     
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax

        $sequence_1 = { 51 57 6a01 53 52 55 ff15???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   57                   | push                edi
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   52                   | push                edx
            //   55                   | push                ebp
            //   ff15????????         |                     

        $sequence_2 = { c686c800000043 c6864b01000043 c7466878920310 6a0d e8???????? 59 8365fc00 }
            // n = 7, score = 100
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466878920310       | mov                 dword ptr [esi + 0x68], 0x10039278
            //   6a0d                 | push                0xd
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_3 = { 0f8788000000 0fb69028720010 ff249508720010 33c0 83c40c c3 8b4644 }
            // n = 7, score = 100
            //   0f8788000000         | ja                  0x8e
            //   0fb69028720010       | movzx               edx, byte ptr [eax + 0x10007228]
            //   ff249508720010       | jmp                 dword ptr [edx*4 + 0x10007208]
            //   33c0                 | xor                 eax, eax
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   8b4644               | mov                 eax, dword ptr [esi + 0x44]

        $sequence_4 = { 57 8b78f4 894dfc 85db }
            // n = 4, score = 100
            //   57                   | push                edi
            //   8b78f4               | mov                 edi, dword ptr [eax - 0xc]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   85db                 | test                ebx, ebx

        $sequence_5 = { 0430 0fb64c2426 8844242f 8bc1 c1e804 83f809 }
            // n = 6, score = 100
            //   0430                 | add                 al, 0x30
            //   0fb64c2426           | movzx               ecx, byte ptr [esp + 0x26]
            //   8844242f             | mov                 byte ptr [esp + 0x2f], al
            //   8bc1                 | mov                 eax, ecx
            //   c1e804               | shr                 eax, 4
            //   83f809               | cmp                 eax, 9

        $sequence_6 = { 8984242c040000 8b842434040000 53 55 56 57 8bf1 }
            // n = 7, score = 100
            //   8984242c040000       | mov                 dword ptr [esp + 0x42c], eax
            //   8b842434040000       | mov                 eax, dword ptr [esp + 0x434]
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx

        $sequence_7 = { 81ec54020000 a1???????? 33c4 8984244c020000 8b842458020000 55 }
            // n = 6, score = 100
            //   81ec54020000         | sub                 esp, 0x254
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   8984244c020000       | mov                 dword ptr [esp + 0x24c], eax
            //   8b842458020000       | mov                 eax, dword ptr [esp + 0x258]
            //   55                   | push                ebp

        $sequence_8 = { b903000000 668994249c000000 668984249e000000 66898c24a0000000 ba01000000 66899424a2000000 b809000000 }
            // n = 7, score = 100
            //   b903000000           | mov                 ecx, 3
            //   668994249c000000     | mov                 word ptr [esp + 0x9c], dx
            //   668984249e000000     | mov                 word ptr [esp + 0x9e], ax
            //   66898c24a0000000     | mov                 word ptr [esp + 0xa0], cx
            //   ba01000000           | mov                 edx, 1
            //   66899424a2000000     | mov                 word ptr [esp + 0xa2], dx
            //   b809000000           | mov                 eax, 9

        $sequence_9 = { e9???????? 8b442410 6a04 56 50 8bde c744242400000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   6a04                 | push                4
            //   56                   | push                esi
            //   50                   | push                eax
            //   8bde                 | mov                 ebx, esi
            //   c744242400000000     | mov                 dword ptr [esp + 0x24], 0

    condition:
        7 of them and filesize < 581632
}