rule win_newpass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.newpass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newpass"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c89642438 4c89742428 48ffc0 418bf0 4c8bf2 }
            // n = 5, score = 700
            //   4c89642438           | mov                 eax, ebx
            //   4c89742428           | dec                 eax
            //   48ffc0               | mov                 ebx, dword ptr [esp + 0x70]
            //   418bf0               | dec                 eax
            //   4c8bf2               | mov                 esi, dword ptr [esp + 0x78]

        $sequence_1 = { 4c8bc3 4c8d4820 4889442420 e8???????? 488b442440 4883c028 4883c430 }
            // n = 7, score = 700
            //   4c8bc3               | dec                 eax
            //   4c8d4820             | cmp                 dword ptr [esp + 0x78], 0x10
            //   4889442420           | jb                  0x1b2d
            //   e8????????           |                     
            //   488b442440           | dec                 eax
            //   4883c028             | mov                 dword ptr [ebp - 0x48], 0xf
            //   4883c430             | dec                 esp

        $sequence_2 = { cc 4885d2 7509 33c9 ff15???????? cc 4533c9 }
            // n = 7, score = 700
            //   cc                   | mov                 dword ptr [esp + 0x98], eax
            //   4885d2               | dec                 ecx
            //   7509                 | mov                 ebp, ecx
            //   33c9                 | dec                 ecx
            //   ff15????????         |                     
            //   cc                   | mov                 esi, eax
            //   4533c9               | dec                 eax

        $sequence_3 = { 488b4c2430 4885c9 7417 488b11 ff5210 4885c0 740c }
            // n = 7, score = 700
            //   488b4c2430           | mov                 eax, edi
            //   4885c9               | nop                 dword ptr [eax]
            //   7417                 | dec                 ecx
            //   488b11               | inc                 eax
            //   ff5210               | inc                 edx
            //   4885c0               | cmp                 byte ptr [eax + eax], 0
            //   740c                 | dec                 ebp

        $sequence_4 = { 66895d00 6685c0 7505 4c8bc3 eb0f 4c8bc7 90 }
            // n = 7, score = 700
            //   66895d00             | mov                 dword ptr [esi], esi
            //   6685c0               | dec                 esp
            //   7505                 | mov                 dword ptr [esi + 8], esi
            //   4c8bc3               | dec                 esp
            //   eb0f                 | mov                 dword ptr [esi + 0x10], esi
            //   4c8bc7               | jmp                 0x1193
            //   90                   | dec                 ecx

        $sequence_5 = { e8???????? 488bf8 eb03 488bfe 488d55d8 e8???????? 488bd8 }
            // n = 7, score = 700
            //   e8????????           |                     
            //   488bf8               | dec                 eax
            //   eb03                 | mov                 dword ptr [esp + 0x110], ebx
            //   488bfe               | dec                 eax
            //   488d55d8             | xor                 eax, esp
            //   e8????????           |                     
            //   488bd8               | dec                 eax

        $sequence_6 = { b850800000 e8???????? 482be0 48c7442428feffffff 48899c2470800000 4889b42478800000 488b05???????? }
            // n = 7, score = 700
            //   b850800000           | inc                 ecx
            //   e8????????           |                     
            //   482be0               | mov                 ecx, edi
            //   48c7442428feffffff     | dec    eax
            //   48899c2470800000     | mov                 edx, ebx
            //   4889b42478800000     | dec                 eax
            //   488b05????????       |                     

        $sequence_7 = { 84c0 0f84c6000000 488b03 48634804 4803cb 488d9424c8000000 e8???????? }
            // n = 7, score = 700
            //   84c0                 | inc                 ecx
            //   0f84c6000000         | inc                 eax
            //   488b03               | dec                 eax
            //   48634804             | cmp                 eax, ecx
            //   4803cb               | jl                  0x3a3
            //   488d9424c8000000     | cmp                 dword ptr [eax], edi
            //   e8????????           |                     

        $sequence_8 = { 4d8d0c18 482bf9 48c1ff05 488bcf 48d1e9 498bc2 482bc1 }
            // n = 7, score = 700
            //   4d8d0c18             | jmp                 0x346
            //   482bf9               | dec                 eax
            //   48c1ff05             | lea                 eax, [0x82440]
            //   488bcf               | dec                 eax
            //   48d1e9               | mov                 dword ptr [ebp + 0x30], 0xf
            //   498bc2               | dec                 eax
            //   482bc1               | mov                 dword ptr [ebp + 0x28], esi

        $sequence_9 = { 57 4154 4155 4156 4157 488dac24d8deffff b828220000 }
            // n = 7, score = 700
            //   57                   | jmp                 0x1d88
            //   4154                 | dec                 eax
            //   4155                 | lea                 eax, [0x6c9af]
            //   4156                 | cmp                 byte ptr [eax], 0
            //   4157                 | jne                 0x1d95
            //   488dac24d8deffff     | dec                 ebp
            //   b828220000           | mov                 eax, edi

    condition:
        7 of them and filesize < 2654208
}