rule win_newposthings_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.newposthings."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newposthings"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec0c 8b4508 8b483c 01c1 813950450000 7551 8d5178 }
            // n = 7, score = 100
            //   83ec0c               | sub                 esp, 0xc
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b483c               | mov                 ecx, dword ptr [eax + 0x3c]
            //   01c1                 | add                 ecx, eax
            //   813950450000         | cmp                 dword ptr [ecx], 0x4550
            //   7551                 | jne                 0x53
            //   8d5178               | lea                 edx, [ecx + 0x78]

        $sequence_1 = { 68ae520110 64a100000000 50 81ec28010000 a1???????? 33c5 }
            // n = 6, score = 100
            //   68ae520110           | push                0x100152ae
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   81ec28010000         | sub                 esp, 0x128
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp

        $sequence_2 = { 8d85f0fcffff 50 6801010000 6a00 c785ecfcffff00000000 }
            // n = 5, score = 100
            //   8d85f0fcffff         | lea                 eax, [ebp - 0x310]
            //   50                   | push                eax
            //   6801010000           | push                0x101
            //   6a00                 | push                0
            //   c785ecfcffff00000000     | mov    dword ptr [ebp - 0x314], 0

        $sequence_3 = { ff750c e8???????? 83c404 c745200f000000 c7451c00000000 c6450c00 b801000000 }
            // n = 7, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c745200f000000       | mov                 dword ptr [ebp + 0x20], 0xf
            //   c7451c00000000       | mov                 dword ptr [ebp + 0x1c], 0
            //   c6450c00             | mov                 byte ptr [ebp + 0xc], 0
            //   b801000000           | mov                 eax, 1

        $sequence_4 = { 8bce e8???????? c745fcffffffff ff36 e8???????? 83c404 8b4df4 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_5 = { 833cf5c000021000 7513 56 e8???????? }
            // n = 4, score = 100
            //   833cf5c000021000     | cmp                 dword ptr [esi*8 + 0x100200c0], 0
            //   7513                 | jne                 0x15
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_6 = { 57 a1???????? 33c4 50 8d442420 64a300000000 68f0110210 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   50                   | push                eax
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   68f0110210           | push                0x100211f0

        $sequence_7 = { c68518ffffff00 c645fc10 837d9010 720e ffb57cffffff }
            // n = 5, score = 100
            //   c68518ffffff00       | mov                 byte ptr [ebp - 0xe8], 0
            //   c645fc10             | mov                 byte ptr [ebp - 4], 0x10
            //   837d9010             | cmp                 dword ptr [ebp - 0x70], 0x10
            //   720e                 | jb                  0x10
            //   ffb57cffffff         | push                dword ptr [ebp - 0x84]

        $sequence_8 = { 0fb6bc3890b70110 8bc7 c1e804 89bdc4fdffff 8bbde8fdffff 8985c4fdffff }
            // n = 6, score = 100
            //   0fb6bc3890b70110     | movzx               edi, byte ptr [eax + edi + 0x1001b790]
            //   8bc7                 | mov                 eax, edi
            //   c1e804               | shr                 eax, 4
            //   89bdc4fdffff         | mov                 dword ptr [ebp - 0x23c], edi
            //   8bbde8fdffff         | mov                 edi, dword ptr [ebp - 0x218]
            //   8985c4fdffff         | mov                 dword ptr [ebp - 0x23c], eax

        $sequence_9 = { 83c40c 8d842474040000 6890010000 50 6a00 ff15???????? }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8d842474040000       | lea                 eax, [esp + 0x474]
            //   6890010000           | push                0x190
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 827392
}