rule win_newsreels_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.newsreels."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.newsreels"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1e902 f3a5 a1???????? 8bcd 83e103 }
            // n = 5, score = 100
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   a1????????           |                     
            //   8bcd                 | mov                 ecx, ebp
            //   83e103               | and                 ecx, 3

        $sequence_1 = { 83c41c 85f6 750b 5f }
            // n = 4, score = 100
            //   83c41c               | add                 esp, 0x1c
            //   85f6                 | test                esi, esi
            //   750b                 | jne                 0xd
            //   5f                   | pop                 edi

        $sequence_2 = { ff15???????? 8b8c241c030000 8dbc240c010000 51 83c9ff 33c0 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b8c241c030000       | mov                 ecx, dword ptr [esp + 0x31c]
            //   8dbc240c010000       | lea                 edi, [esp + 0x10c]
            //   51                   | push                ecx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 56 ff15???????? 8be8 85ed 750e 56 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax
            //   85ed                 | test                ebp, ebp
            //   750e                 | jne                 0x10
            //   56                   | push                esi

        $sequence_4 = { 83c410 c6043000 5e 5d 5b 81c4a0010000 }
            // n = 6, score = 100
            //   83c410               | add                 esp, 0x10
            //   c6043000             | mov                 byte ptr [eax + esi], 0
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   81c4a0010000         | add                 esp, 0x1a0

        $sequence_5 = { 83c408 85db 750a 5e 5d }
            // n = 5, score = 100
            //   83c408               | add                 esp, 8
            //   85db                 | test                ebx, ebx
            //   750a                 | jne                 0xc
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_6 = { 83c703 c1f902 83e13f 897c2424 8a81305d4000 88441efc 8a4c2ffd }
            // n = 7, score = 100
            //   83c703               | add                 edi, 3
            //   c1f902               | sar                 ecx, 2
            //   83e13f               | and                 ecx, 0x3f
            //   897c2424             | mov                 dword ptr [esp + 0x24], edi
            //   8a81305d4000         | mov                 al, byte ptr [ecx + 0x405d30]
            //   88441efc             | mov                 byte ptr [esi + ebx - 4], al
            //   8a4c2ffd             | mov                 cl, byte ptr [edi + ebp - 3]

        $sequence_7 = { 80e301 881c30 40 83f808 }
            // n = 4, score = 100
            //   80e301               | and                 bl, 1
            //   881c30               | mov                 byte ptr [eax + esi], bl
            //   40                   | inc                 eax
            //   83f808               | cmp                 eax, 8

        $sequence_8 = { 7415 53 e8???????? 83c404 33c0 }
            // n = 5, score = 100
            //   7415                 | je                  0x17
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { f7d1 2bf9 6a4d 8bf7 8bd9 8bfa 83c9ff }
            // n = 7, score = 100
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   6a4d                 | push                0x4d
            //   8bf7                 | mov                 esi, edi
            //   8bd9                 | mov                 ebx, ecx
            //   8bfa                 | mov                 edi, edx
            //   83c9ff               | or                  ecx, 0xffffffff

    condition:
        7 of them and filesize < 65536
}