rule win_nightclub_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nightclub."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nightclub"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8d45f4 64a300000000 8b4508 8d75d4 c745ec00000000 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d75d4               | lea                 esi, [ebp - 0x2c]
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   e8????????           |                     

        $sequence_1 = { 889d5ffeffff ff15???????? 8d855efeffff c645fc05 50 }
            // n = 5, score = 100
            //   889d5ffeffff         | mov                 byte ptr [ebp - 0x1a1], bl
            //   ff15????????         |                     
            //   8d855efeffff         | lea                 eax, [ebp - 0x1a2]
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   50                   | push                eax

        $sequence_2 = { c645fc0c ff15???????? 85c0 0f8827010000 8b0d???????? 8b11 52 }
            // n = 7, score = 100
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8827010000         | js                  0x12d
            //   8b0d????????         |                     
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   52                   | push                edx

        $sequence_3 = { 83c404 85c9 7517 33c0 8b450c 8d0442 5f }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   85c9                 | test                ecx, ecx
            //   7517                 | jne                 0x19
            //   33c0                 | xor                 eax, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8d0442               | lea                 eax, [edx + eax*2]
            //   5f                   | pop                 edi

        $sequence_4 = { 8bff 8d45d4 8bcf e8???????? 50 c745fc01000000 8b4e08 }
            // n = 7, score = 100
            //   8bff                 | mov                 edi, edi
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   50                   | push                eax
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]

        $sequence_5 = { ff15???????? 83c610 3bf7 75f1 8b4304 50 ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c610               | add                 esi, 0x10
            //   3bf7                 | cmp                 esi, edi
            //   75f1                 | jne                 0xfffffff3
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { 83f806 7753 0fb69058720010 ff249550720010 ba???????? 8bc7 8d742430 }
            // n = 7, score = 100
            //   83f806               | cmp                 eax, 6
            //   7753                 | ja                  0x55
            //   0fb69058720010       | movzx               edx, byte ptr [eax + 0x10007258]
            //   ff249550720010       | jmp                 dword ptr [edx*4 + 0x10007250]
            //   ba????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   8d742430             | lea                 esi, [esp + 0x30]

        $sequence_7 = { eb03 8945fc a1???????? 8b08 51 6a00 8d4e74 }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   a1????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8d4e74               | lea                 ecx, [esi + 0x74]

        $sequence_8 = { 834dec01 85c0 7505 a1???????? 8bf0 8d4900 }
            // n = 6, score = 100
            //   834dec01             | or                  dword ptr [ebp - 0x14], 1
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   a1????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8d4900               | lea                 ecx, [ecx]

        $sequence_9 = { 72e6 b892010000 5f 5e 8b4df8 33cd e8???????? }
            // n = 7, score = 100
            //   72e6                 | jb                  0xffffffe8
            //   b892010000           | mov                 eax, 0x192
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 247808
}