rule win_nightdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nightdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nightdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 ff15???????? 8b45fc 8b08 51 e8???????? 83c404 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { 51 8d4dac e8???????? c7458800000000 eb09 8b5588 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   e8????????           |                     
            //   c7458800000000       | mov                 dword ptr [ebp - 0x78], 0
            //   eb09                 | jmp                 0xb
            //   8b5588               | mov                 edx, dword ptr [ebp - 0x78]

        $sequence_2 = { 0f840c020000 6a00 8d4dc0 51 8d55c8 52 }
            // n = 6, score = 100
            //   0f840c020000         | je                  0x212
            //   6a00                 | push                0
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   51                   | push                ecx
            //   8d55c8               | lea                 edx, [ebp - 0x38]
            //   52                   | push                edx

        $sequence_3 = { 6a01 e8???????? 83c404 8945fc 8b4d10 51 8b550c }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_4 = { 85c0 7505 8b45fc eb1c 8b4dfc e8???????? 8b4d08 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   eb1c                 | jmp                 0x1e
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_5 = { e9???????? 8b4518 3b450c 7765 8b4d18 51 8b4df0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]
            //   7765                 | ja                  0x67
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   51                   | push                ecx
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_6 = { ff15???????? 8945e0 837de0ff 7524 ff15???????? 8945dc }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   837de0ff             | cmp                 dword ptr [ebp - 0x20], -1
            //   7524                 | jne                 0x26
            //   ff15????????         |                     
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_7 = { 51 ff15???????? 85c0 0f853a030000 8d95d4feffff 52 8d85d4f6ffff }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f853a030000         | jne                 0x340
            //   8d95d4feffff         | lea                 edx, [ebp - 0x12c]
            //   52                   | push                edx
            //   8d85d4f6ffff         | lea                 eax, [ebp - 0x92c]

        $sequence_8 = { 83c404 b001 e9???????? 83ff0b 7510 8bd6 8bcb }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   b001                 | mov                 al, 1
            //   e9????????           |                     
            //   83ff0b               | cmp                 edi, 0xb
            //   7510                 | jne                 0x12
            //   8bd6                 | mov                 edx, esi
            //   8bcb                 | mov                 ecx, ebx

        $sequence_9 = { 8b45f0 c7400c00000000 68???????? 8b4df0 83c110 }
            // n = 5, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   c7400c00000000       | mov                 dword ptr [eax + 0xc], 0
            //   68????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c110               | add                 ecx, 0x10

    condition:
        7 of them and filesize < 1124352
}