rule win_nighthawk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nighthawk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nighthawk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4885c9 7405 e8???????? 4883631000 48c743180f000000 c60300 4883c320 }
            // n = 7, score = 100
            //   4885c9               | test                ecx, ecx
            //   7405                 | je                  0x178
            //   e8????????           |                     
            //   4883631000           | dec                 esp
            //   48c743180f000000     | mov                 dword ptr [ebp], edi
            //   c60300               | dec                 eax
            //   4883c320             | cmp                 dword ptr [ebp + 8], 8

        $sequence_1 = { e8???????? 488b4810 4883781810 7203 488b00 4885c9 7425 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b4810             | mov                 eax, dword ptr [ebx + 0x48]
            //   4883781810           | dec                 esp
            //   7203                 | lea                 eax, [ebp + 0x20]
            //   488b00               | inc                 ebp
            //   4885c9               | mov                 ecx, esi
            //   7425                 | mov                 dword ptr [ebp + 0x20], eax

        $sequence_2 = { 4c89b5a0010000 4c89bda8010000 4488b590010000 48399dc8010000 7211 488b8db0010000 4885c9 }
            // n = 7, score = 100
            //   4c89b5a0010000       | jne                 0x10e4
            //   4c89bda8010000       | dec                 ecx
            //   4488b590010000       | mov                 ecx, dword ptr [ebp + 0x10]
            //   48399dc8010000       | dec                 ecx
            //   7211                 | mov                 edx, ecx
            //   488b8db0010000       | dec                 ebp
            //   4885c9               | mov                 esp, dword ptr [ecx + 0x18]

        $sequence_3 = { 4c89742430 4c89742440 48c74424480f000000 41b814000000 488d15deaf0500 488d4c2430 e8???????? }
            // n = 7, score = 100
            //   4c89742430           | mov                 ebx, dword ptr [esp + 0x50]
            //   4c89742440           | dec                 eax
            //   48c74424480f000000     | add    esp, 0x20
            //   41b814000000         | pop                 edi
            //   488d15deaf0500       | pop                 esi
            //   488d4c2430           | pop                 ebp
            //   e8????????           |                     

        $sequence_4 = { 4c8b43f8 4d85c0 742b 4883c8ff 48ffc0 44382407 75f7 }
            // n = 7, score = 100
            //   4c8b43f8             | mov                 eax, dword ptr [eax]
            //   4d85c0               | movsx               edi, byte ptr [edx + eax]
            //   742b                 | inc                 eax
            //   4883c8ff             | cmp                 bh, 0x2d
            //   48ffc0               | je                  0xe13
            //   44382407             | dec                 ecx
            //   75f7                 | mov                 eax, eax

        $sequence_5 = { 4c8b32 492bee 488bc5 48c1f803 480fafc1 4885ed 7473 }
            // n = 7, score = 100
            //   4c8b32               | xor                 ecx, ecx
            //   492bee               | inc                 ecx
            //   488bc5               | mov                 eax, 0x4000
            //   48c1f803             | dec                 eax
            //   480fafc1             | mov                 edx, ebp
            //   4885ed               | mov                 edi, eax
            //   7473                 | cmp                 eax, -1

        $sequence_6 = { 488d542420 488bce e8???????? 90 eb2b 4c892e 41be0f000000 }
            // n = 7, score = 100
            //   488d542420           | mov                 ebx, eax
            //   488bce               | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 esi, eax
            //   eb2b                 | dec                 eax
            //   4c892e               | lea                 ecx, [ebx - 0x101]
            //   41be0f000000         | dec                 eax

        $sequence_7 = { 57 4883ec40 488360f000 488bf1 83601800 488d0da9db0700 8bda }
            // n = 7, score = 100
            //   57                   | dec                 esp
            //   4883ec40             | mov                 eax, edi
            //   488360f000           | dec                 eax
            //   488bf1               | lea                 edx, [0x7bc99]
            //   83601800             | dec                 eax
            //   488d0da9db0700       | lea                 ecx, [esp + 0x50]
            //   8bda                 | dec                 eax

        $sequence_8 = { e9???????? 83fa06 0f8553010000 8d7209 443821 742e 4c8965e0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   83fa06               | dec                 eax
            //   0f8553010000         | mov                 edx, eax
            //   8d7209               | dec                 eax
            //   443821               | lea                 ecx, [ebp + 0x320]
            //   742e                 | inc                 ecx
            //   4c8965e0             | or                  edi, 2

        $sequence_9 = { eb05 448974246c 4889b580020000 4889b590020000 4889bd98020000 41b823000000 488d1537f50700 }
            // n = 7, score = 100
            //   eb05                 | dec                 eax
            //   448974246c           | mov                 dword ptr [ebx], eax
            //   4889b580020000       | dec                 eax
            //   4889b590020000       | mov                 eax, edi
            //   4889bd98020000       | dec                 eax
            //   41b823000000         | mov                 dword ptr [eax], eax
            //   488d1537f50700       | dec                 eax

    condition:
        7 of them and filesize < 1949696
}