rule win_nightshade_c2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nightshade_c2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nightshade_c2"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744243000000000 488b842438010000 4889442428 89542420 448bcf 4533c0 33d2 }
            // n = 7, score = 100
            //   c744243000000000     | lea                 eax, [esp + 0x78]
            //   488b842438010000     | rep stosb           byte ptr es:[edi], al
            //   4889442428           | cmp                 dword ptr [esp + 0x40], 0x20
            //   89542420             | jne                 0x931
            //   448bcf               | mov                 eax, 2
            //   4533c0               | dec                 eax
            //   33d2                 | imul                eax, eax, 0

        $sequence_1 = { c744242000000000 eb0b 8b442420 83c002 89442420 8b842480000000 39442420 }
            // n = 7, score = 100
            //   c744242000000000     | mov                 edi, eax
            //   eb0b                 | xor                 eax, eax
            //   8b442420             | mov                 ecx, 8
            //   83c002               | rep stosb           byte ptr es:[edi], al
            //   89442420             | rep stosb           byte ptr es:[edi], al
            //   8b842480000000       | dec                 eax
            //   39442420             | lea                 eax, [esp + 0x48]

        $sequence_2 = { 488b4c2458 ff15???????? 90 48837c247000 740c 488b4c2470 ff15???????? }
            // n = 7, score = 100
            //   488b4c2458           | mov                 dword ptr [esp + 0x108], 0
            //   ff15????????         |                     
            //   90                   | mov                 eax, 8
            //   48837c247000         | dec                 eax
            //   740c                 | imul                eax, eax, 0
            //   488b4c2470           | dec                 eax
            //   ff15????????         |                     

        $sequence_3 = { 8b442458 89442428 488b442460 4889442420 448b4c2454 4c8b442470 33d2 }
            // n = 7, score = 100
            //   8b442458             | mov                 dword ptr [esp + 0x40], 0
            //   89442428             | dec                 eax
            //   488b442460           | lea                 eax, [esp + 0x78]
            //   4889442420           | dec                 eax
            //   448b4c2454           | mov                 edi, eax
            //   4c8b442470           | xor                 eax, eax
            //   33d2                 | mov                 ecx, 0x10

        $sequence_4 = { 8b0c24 486bc903 488b542408 0fb60c0a 81e1ff000000 0bc1 8b0c24 }
            // n = 7, score = 100
            //   8b0c24               | rep stosb           byte ptr es:[edi], al
            //   486bc903             | mov                 dword ptr [esp + 0x20], 0
            //   488b542408           | dec                 eax
            //   0fb60c0a             | mov                 dword ptr [esp + 0x28], 0
            //   81e1ff000000         | dec                 eax
            //   0bc1                 | mov                 eax, dword ptr [esp + 0x50]
            //   8b0c24               | dec                 eax

        $sequence_5 = { ff15???????? ff15???????? 90 488b442440 488bc8 e8???????? 90 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   90                   | xor                 ebx, ebx
            //   488b442440           | dec                 eax
            //   488bc8               | cmp                 eax, -2
            //   e8????????           |                     
            //   90                   | jne                 0xad9

        $sequence_6 = { 48638424b8000000 488b8c24b0000000 4803c8 488bc1 4889442430 c744244400000000 eb0b }
            // n = 7, score = 100
            //   48638424b8000000     | dec                 eax
            //   488b8c24b0000000     | mov                 ecx, dword ptr [esp + 0x80]
            //   4803c8               | dec                 eax
            //   488bc1               | mov                 ecx, dword ptr [esp + 0x80]
            //   4889442430           | dec                 eax
            //   c744244400000000     | mov                 ecx, dword ptr [esp + 0x58]
            //   eb0b                 | dec                 eax

        $sequence_7 = { 85c0 7479 488b542438 488d0d0ce50100 e8???????? 85c0 }
            // n = 6, score = 100
            //   85c0                 | dec                 eax
            //   7479                 | mov                 ecx, dword ptr [esp + 0x40]
            //   488b542438           | xor                 eax, eax
            //   488d0d0ce50100       | cmp                 eax, 1
            //   e8????????           |                     
            //   85c0                 | je                  0x1c41

        $sequence_8 = { ff15???????? 85c0 7505 e9???????? 41b810000000 488d9424b8000000 488b4c2448 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   7505                 | mov                 dword ptr [esp + 0x40], eax
            //   e9????????           |                     
            //   41b810000000         | dec                 eax
            //   488d9424b8000000     | mov                 ecx, dword ptr [esp + 0x40]
            //   488b4c2448           | dec                 eax

        $sequence_9 = { 8b442424 8b4c2460 2bc8 8bc1 3dffff0000 7e0a c7442420ffff0000 }
            // n = 7, score = 100
            //   8b442424             | mov                 eax, dword ptr [esp + 0x28]
            //   8b4c2460             | mov                 dword ptr [esp + 0x24], 0
            //   2bc8                 | mov                 dword ptr [esp + 0xa0], 0
            //   8bc1                 | dec                 eax
            //   3dffff0000           | lea                 eax, [esp + 0xd8]
            //   7e0a                 | dec                 eax
            //   c7442420ffff0000     | mov                 edi, eax

    condition:
        7 of them and filesize < 458752
}