rule win_nightsky_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nightsky."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nightsky"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bda 420fb6bc3010680500 418bc3 c1e708 48c1e810 0fb6c8 420fb6843110680500 }
            // n = 7, score = 100
            //   8bda                 | je                  0xdee
            //   420fb6bc3010680500     | nop    dword ptr [eax + eax]
            //   418bc3               | xor                 edx, edx
            //   c1e708               | test                eax, eax
            //   48c1e810             | test                eax, eax
            //   0fb6c8               | je                  0xe1a
            //   420fb6843110680500     | dec    eax

        $sequence_1 = { 83f806 0f879c010000 488d155277ffff 4898 8b8c82948a0000 4803ca ffe1 }
            // n = 7, score = 100
            //   83f806               | dec                 eax
            //   0f879c010000         | mov                 edx, edi
            //   488d155277ffff       | dec                 eax
            //   4898                 | lea                 ebp, [0x52f66]
            //   8b8c82948a0000       | jne                 0x7b0
            //   4803ca               | dec                 esp
            //   ffe1                 | lea                 ecx, [esp + 0x890]

        $sequence_2 = { 488bd7 498bcc ff15???????? 4c8d4c2470 48895c2420 41b800000800 498bd6 }
            // n = 7, score = 100
            //   488bd7               | dec                 eax
            //   498bcc               | mov                 esp, dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   4c8d4c2470           | dec                 eax
            //   48895c2420           | mov                 eax, dword ptr [ebp - 0x78]
            //   41b800000800         | dec                 eax
            //   498bd6               | add                 edi, 0x80000

        $sequence_3 = { 4883c602 66833e00 758d 483bf5 765e 482bf5 48d1fe }
            // n = 7, score = 100
            //   4883c602             | inc                 esp
            //   66833e00             | or                  eax, ecx
            //   758d                 | inc                 ecx
            //   483bf5               | movzx               ecx, cl
            //   765e                 | inc                 ecx
            //   482bf5               | shl                 eax, 8
            //   48d1fe               | inc                 edx

        $sequence_4 = { 488905???????? 4885db 488d059af90400 488905???????? b830000000 480f44d8 486305???????? }
            // n = 7, score = 100
            //   488905????????       |                     
            //   4885db               | inc                 ebp
            //   488d059af90400       | xor                 eax, dword ptr [esi + ecx*4 + 0x46930]
            //   488905????????       |                     
            //   b830000000           | inc                 ebp
            //   480f44d8             | mov                 eax, dword ptr [esi + edx*4 + 0x46b50]
            //   486305????????       |                     

        $sequence_5 = { 4983f940 72eb e9???????? 488d059e1f0000 48b90000000000000080 488987c8000000 488d0576900200 }
            // n = 7, score = 100
            //   4983f940             | dec                 ecx
            //   72eb                 | cmp                 ecx, 0x40
            //   e9????????           |                     
            //   488d059e1f0000       | jb                  0x7ba
            //   48b90000000000000080     | mov    dword ptr [edi + 8], 1
            //   488987c8000000       | dec                 eax
            //   488d0576900200       | lea                 eax, [0x289e7]

        $sequence_6 = { 488d05ba8b0200 c7475001000000 48c7475804000000 48894778 488d0508520300 c7476801000000 48c7477004000000 }
            // n = 7, score = 100
            //   488d05ba8b0200       | lea                 eax, [0x2941b]
            //   c7475001000000       | mov                 dword ptr [edi + 8], 1
            //   48c7475804000000     | dec                 eax
            //   48894778             | mov                 dword ptr [edi + 0x10], 3
            //   488d0508520300       | dec                 eax
            //   c7476801000000       | mov                 dword ptr [edi + 0x30], eax
            //   48c7477004000000     | dec                 eax

        $sequence_7 = { e8???????? 486305???????? 4c8d0516060500 83f814 0f8d99000000 488bc8 488d0480 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   486305????????       |                     
            //   4c8d0516060500       | ror                 ebx, 2
            //   83f814               | test                sp, cx
            //   0f8d99000000         | clc                 
            //   488bc8               | inc                 ecx
            //   488d0480             | push                ebx

        $sequence_8 = { 458b849610710500 48c1eb18 4533848e10810500 4533848610640500 410fb6c3 49c1eb08 410fb6ca }
            // n = 7, score = 100
            //   458b849610710500     | dec                 ebp
            //   48c1eb18             | lea                 ecx, [esp + 0x10]
            //   4533848e10810500     | dec                 esp
            //   4533848610640500     | lea                 esi, [0x1edf5]
            //   410fb6c3             | mov                 ebp, 4
            //   49c1eb08             | dec                 esp
            //   410fb6ca             | lea                 ebx, [eax + eax*2]

        $sequence_9 = { 0fb64103 468b8c8710750500 0fb6943810630500 0fb64102 44338c9710640500 0fb6943810630500 }
            // n = 6, score = 100
            //   0fb64103             | lea                 edi, [ecx - 8]
            //   468b8c8710750500     | dec                 esp
            //   0fb6943810630500     | lea                 ecx, [0xfffe95ff]
            //   0fb64102             | jb                  0x481
            //   44338c9710640500     | dec                 eax
            //   0fb6943810630500     | mov                 ecx, dword ptr [ebp - 0x80]

    condition:
        7 of them and filesize < 19536896
}