rule win_nikihttp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nikihttp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nikihttp"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81fb41cd9ec8 75f0 bbcc8dc70b 662e0f1f840000000000 90 81fbe1bcb5f8 7e28 }
            // n = 7, score = 100
            //   81fb41cd9ec8         | xor                 edx, edx
            //   75f0                 | inc                 ecx
            //   bbcc8dc70b           | mov                 eax, 0x800
            //   662e0f1f840000000000     | dec    eax
            //   90                   | lea                 ecx, [ebp + 0x1330]
            //   81fbe1bcb5f8         | xor                 edx, edx
            //   7e28                 | inc                 ecx

        $sequence_1 = { bf35a51c0f 41bed886138b 41bf87556a70 0f1f440000 81ffdc69e0ab 0f84b0000000 81ff35a51c0f }
            // n = 7, score = 100
            //   bf35a51c0f           | inc                 ecx
            //   41bed886138b         | cmovne              esi, edx
            //   41bf87556a70         | test                bl, bl
            //   0f1f440000           | inc                 ecx
            //   81ffdc69e0ab         | cmovne              esi, edx
            //   0f84b0000000         | jne                 0xbd
            //   81ff35a51c0f         | movzx               ebx, byte ptr [esp + 0x2c]

        $sequence_2 = { 81fe7b887e5d 740a 81fee5f97f04 75f0 eb07 bee5f97f04 ebe7 }
            // n = 7, score = 100
            //   81fe7b887e5d         | inc                 esp
            //   740a                 | cmovne              esi, ecx
            //   81fee5f97f04         | mov                 ecx, 0x96d144b1
            //   75f0                 | inc                 ecx
            //   eb07                 | mov                 edi, 0x722bb527
            //   bee5f97f04           | inc                 ecx
            //   ebe7                 | mov                 esp, 0x69f865d3

        $sequence_3 = { b8ca43fd9f e9???????? 488b8d98000000 488b9580000000 488b4580 4883ec20 ffd0 }
            // n = 7, score = 100
            //   b8ca43fd9f           | dec                 eax
            //   e9????????           |                     
            //   488b8d98000000       | mov                 eax, dword ptr [ebp + 0x470]
            //   488b9580000000       | dec                 eax
            //   488b4580             | add                 eax, 1
            //   4883ec20             | dec                 eax
            //   ffd0                 | mov                 dword ptr [ebp + 0x478], eax

        $sequence_4 = { c785d000000003000000 8b8dd0000000 0fbec9 01c1 bab8c94eab ebab 898dd0000000 }
            // n = 7, score = 100
            //   c785d000000003000000     | cmp    eax, 0x50dbb9e1
            //   8b8dd0000000         | jg                  0x1474
            //   0fbec9               | cmp                 eax, 0xf5896ac
            //   01c1                 | je                  0x3597
            //   bab8c94eab           | cmp                 eax, 0x3ce9b7c8
            //   ebab                 | jne                 0x35e6
            //   898dd0000000         | jle                 0x1407

        $sequence_5 = { bbdd37ea6d ebb4 884d78 8a4d78 884801 c6400200 488b4d00 }
            // n = 7, score = 100
            //   bbdd37ea6d           | mov                 ecx, ebx
            //   ebb4                 | mov                 ecx, 0xf17454d2
            //   884d78               | je                  0x213
            //   8a4d78               | cmp                 ecx, 0x94229d39
            //   884801               | jne                 0x1ef
            //   c6400200             | mov                 edx, 0x14
            //   488b4d00             | dec                 eax

        $sequence_6 = { bb26cfb9cb 660f1f840000000000 81fbf6c7d601 7f28 81fbddb48ecd 7f50 81fb1c10669d }
            // n = 7, score = 100
            //   bb26cfb9cb           | je                  0x362
            //   660f1f840000000000     | cmp    ecx, 0x334d9756
            //   81fbf6c7d601         | jne                 0x2eb
            //   7f28                 | mov                 eax, dword ptr [ebp + 0x894]
            //   81fbddb48ecd         | mov                 ecx, dword ptr [ebp + 0x890]
            //   7f50                 | nop                 
            //   81fb1c10669d         | cmp                 ecx, 0x97fb8291

        $sequence_7 = { 8b442404 8b442404 8b442404 8b442404 8b442404 b837c4eca4 e9???????? }
            // n = 7, score = 100
            //   8b442404             | dec                 eax
            //   8b442404             | mov                 dword ptr [esp + 0x48], eax
            //   8b442404             | mov                 edx, 0xa4cdcd6
            //   8b442404             | dec                 eax
            //   8b442404             | lea                 eax, [esp + 0x40]
            //   b837c4eca4           | dec                 eax
            //   e9????????           |                     

        $sequence_8 = { babec982ec 0f45ea ba51cce543 662e0f1f840000000000 0f1f00 81facbe177f9 7e28 }
            // n = 7, score = 100
            //   babec982ec           | mov                 dword ptr [esp + 0x48], 0x6f
            //   0f45ea               | mov                 edx, 0x21587ead
            //   ba51cce543           | nop                 word ptr [eax + eax]
            //   662e0f1f840000000000     | cmp    edx, 0x8cf96cc
            //   0f1f00               | je                  0x18b2
            //   81facbe177f9         | cmp                 edx, 0x21587ead
            //   7e28                 | mov                 word ptr [eax], cx

        $sequence_9 = { ebe9 89bdd0080000 8b85d0080000 6689431e c785a808000020000000 b813cbdf5e 662e0f1f840000000000 }
            // n = 7, score = 100
            //   ebe9                 | jle                 0x1554
            //   89bdd0080000         | cmp                 edx, 0xa
            //   8b85d0080000         | cmovl               ecx, esi
            //   6689431e             | cmp                 ecx, 0x11c195b6
            //   c785a808000020000000     | jg    0x1534
            //   b813cbdf5e           | cmp                 ecx, 0xc8e0fe51
            //   662e0f1f840000000000     | jg    0x15a4

    condition:
        7 of them and filesize < 2543616
}