rule win_nikitear_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nikitear."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nikitear"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d8d60010000 ffd0 33c0 c74424204004242e 8844242c }
            // n = 5, score = 100
            //   488d8d60010000       | mov                 eax, 0x51eb851f
            //   ffd0                 | add                 ecx, 0x32
            //   33c0                 | inc                 ecx
            //   c74424204004242e     | mov                 byte ptr [eax + 8], dl
            //   8844242c             | inc                 ecx

        $sequence_1 = { 8d419f 3c19 7706 448d49b9 eb24 8d41d0 3c09 }
            // n = 7, score = 100
            //   8d419f               | movzx               edx, byte ptr [ebp - 0x49]
            //   3c19                 | jmp                 0xf83
            //   7706                 | dec                 eax
            //   448d49b9             | lea                 ecx, [ebp - 0x48]
            //   eb24                 | mov                 byte ptr [ebp - 0x3e], bl
            //   8d41d0               | inc                 ecx
            //   3c09                 | call                eax

        $sequence_2 = { 48635708 4c8d3dcce5feff 48035508 0fb60a 83e10f 4a0fbe843908460300 428a8c3918460300 }
            // n = 7, score = 100
            //   48635708             | cmp                 eax, ecx
            //   4c8d3dcce5feff       | cmovg               ebx, ecx
            //   48035508             | xor                 eax, eax
            //   0fb60a               | mov                 ecx, 0x4000
            //   83e10f               | mov                 edx, 0x5f
            //   4a0fbe843908460300     | inc    ecx
            //   428a8c3918460300     | mov                 eax, 0x4000

        $sequence_3 = { 488d4c2440 4885f6 743f 4c8d054ff7fdff 483bca 7333 80390d }
            // n = 7, score = 100
            //   488d4c2440           | dec                 eax
            //   4885f6               | cmp                 ecx, 5
            //   743f                 | jne                 0x5e
            //   4c8d054ff7fdff       | nop                 dword ptr [eax]
            //   483bca               | movzx               eax, byte ptr [ebp - 0x60]
            //   7333                 | add                 al, cl
            //   80390d               | xor                 byte ptr [ebp + ecx - 0x5f], al

        $sequence_4 = { 4c03f3 4c8b6c2460 4b8d0427 4c3bf0 0f94c0 488b4df8 4833cc }
            // n = 7, score = 100
            //   4c03f3               | dec                 eax
            //   4c8b6c2460           | lea                 ecx, [ebp - 0x48]
            //   4b8d0427             | xor                 byte ptr [ebp + eax - 0x48], cl
            //   4c3bf0               | dec                 eax
            //   0f94c0               | inc                 eax
            //   488b4df8             | dec                 eax
            //   4833cc               | cmp                 eax, 0xc

        $sequence_5 = { 488d151e570200 488d0de7560200 e8???????? 85c0 7529 }
            // n = 5, score = 100
            //   488d151e570200       | dec                 eax
            //   488d0de7560200       | inc                 dword ptr [ecx + 0x3df0]
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7529                 | mov                 edx, dword ptr [ecx + 0x3df0]

        $sequence_6 = { 39b42480000000 747b 4c8d0576ce0100 498b04e8 f644f83848 7441 0fb7442470 }
            // n = 7, score = 100
            //   39b42480000000       | cmp                 ecx, eax
            //   747b                 | cmp                 word ptr [edi], 0x22
            //   4c8d0576ce0100       | jne                 0x14a8
            //   498b04e8             | dec                 eax
            //   f644f83848           | lea                 edx, [edi + 2]
            //   7441                 | dec                 eax
            //   0fb7442470           | mov                 ecx, edi

        $sequence_7 = { 44884c2420 41b901000000 4533c0 418bd1 488bcb e8???????? 83e73f }
            // n = 7, score = 100
            //   44884c2420           | je                  0x1f41
            //   41b901000000         | test                ebx, ebx
            //   4533c0               | jle                 0x1f41
            //   418bd1               | test                esi, esi
            //   488bcb               | setne               al
            //   e8????????           |                     
            //   83e73f               | dec                 eax

        $sequence_8 = { 48ffc1 4883f90d 7306 0fb65590 ebea 0fb64591 8bce }
            // n = 7, score = 100
            //   48ffc1               | movups              xmmword ptr [ebx], xmm0
            //   4883f90d             | movups              xmmword ptr [ebx + 0x10], xmm1
            //   7306                 | ja                  0x79e
            //   0fb65590             | nop                 dword ptr [eax]
            //   ebea                 | dec                 ecx
            //   0fb64591             | add                 ecx, eax
            //   8bce                 | inc                 edi

        $sequence_9 = { 4883c227 482bc1 4883c0f8 4883f81f 772a e8???????? 488b4310 }
            // n = 7, score = 100
            //   4883c227             | inc                 eax
            //   482bc1               | shl                 dh, 4
            //   4883c0f8             | shr                 al, 4
            //   4883f81f             | and                 al, 3
            //   772a                 | inc                 ecx
            //   e8????????           |                     
            //   488b4310             | shl                 al, 4

    condition:
        7 of them and filesize < 610304
}