rule win_nimgrabber_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nimgrabber."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nimgrabber"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89e8 e8???????? 8b4310 8d68f8 85c0 0f8469feffff 8b4500 }
            // n = 7, score = 200
            //   89e8                 | mov                 eax, ebp
            //   e8????????           |                     
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   8d68f8               | lea                 ebp, [eax - 8]
            //   85c0                 | test                eax, eax
            //   0f8469feffff         | je                  0xfffffe6f
            //   8b4500               | mov                 eax, dword ptr [ebp]

        $sequence_1 = { 8b4514 89442414 83fa0f 7f5a 8b5d04 8b4500 85db }
            // n = 7, score = 200
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   83fa0f               | cmp                 edx, 0xf
            //   7f5a                 | jg                  0x5c
            //   8b5d04               | mov                 ebx, dword ptr [ebp + 4]
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   85db                 | test                ebx, ebx

        $sequence_2 = { 89f8 25ff010000 0fb78446e4030000 6685c0 0f85a0090000 89f8 89fa }
            // n = 7, score = 200
            //   89f8                 | mov                 eax, edi
            //   25ff010000           | and                 eax, 0x1ff
            //   0fb78446e4030000     | movzx               eax, word ptr [esi + eax*2 + 0x3e4]
            //   6685c0               | test                ax, ax
            //   0f85a0090000         | jne                 0x9a6
            //   89f8                 | mov                 eax, edi
            //   89fa                 | mov                 edx, edi

        $sequence_3 = { 8b442420 8b00 39c6 0f8256feffff 83e801 893424 89442404 }
            // n = 7, score = 200
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   39c6                 | cmp                 esi, eax
            //   0f8256feffff         | jb                  0xfffffe5c
            //   83e801               | sub                 eax, 1
            //   893424               | mov                 dword ptr [esp], esi
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_4 = { 8b44243c 8b4c2460 8d5c0808 0fb64708 3c2a 0f849b0b0000 0f87f7000000 }
            // n = 7, score = 200
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   8b4c2460             | mov                 ecx, dword ptr [esp + 0x60]
            //   8d5c0808             | lea                 ebx, [eax + ecx + 8]
            //   0fb64708             | movzx               eax, byte ptr [edi + 8]
            //   3c2a                 | cmp                 al, 0x2a
            //   0f849b0b0000         | je                  0xba1
            //   0f87f7000000         | ja                  0xfd

        $sequence_5 = { 8d56f8 83e808 8946f8 83f807 0f861a020000 8b4304 85c0 }
            // n = 7, score = 200
            //   8d56f8               | lea                 edx, [esi - 8]
            //   83e808               | sub                 eax, 8
            //   8946f8               | mov                 dword ptr [esi - 8], eax
            //   83f807               | cmp                 eax, 7
            //   0f861a020000         | jbe                 0x220
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   85c0                 | test                eax, eax

        $sequence_6 = { 83ff01 0f8492000000 8b11 8d6ffe 39d5 7211 83ea01 }
            // n = 7, score = 200
            //   83ff01               | cmp                 edi, 1
            //   0f8492000000         | je                  0x98
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8d6ffe               | lea                 ebp, [edi - 2]
            //   39d5                 | cmp                 ebp, edx
            //   7211                 | jb                  0x13
            //   83ea01               | sub                 edx, 1

        $sequence_7 = { 037304 8b5208 0fb6f8 89f1 897c2440 83c42c 5b }
            // n = 7, score = 200
            //   037304               | add                 esi, dword ptr [ebx + 4]
            //   8b5208               | mov                 edx, dword ptr [edx + 8]
            //   0fb6f8               | movzx               edi, al
            //   89f1                 | mov                 ecx, esi
            //   897c2440             | mov                 dword ptr [esp + 0x40], edi
            //   83c42c               | add                 esp, 0x2c
            //   5b                   | pop                 ebx

        $sequence_8 = { e8???????? c1e807 83f001 83e001 e9???????? 837c24687f 0f8ea80b0000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c1e807               | shr                 eax, 7
            //   83f001               | xor                 eax, 1
            //   83e001               | and                 eax, 1
            //   e9????????           |                     
            //   837c24687f           | cmp                 dword ptr [esp + 0x68], 0x7f
            //   0f8ea80b0000         | jle                 0xbae

        $sequence_9 = { 037c2440 0f49c7 83c208 89542414 89c5 89c8 25ffffff3f }
            // n = 7, score = 200
            //   037c2440             | add                 edi, dword ptr [esp + 0x40]
            //   0f49c7               | cmovns              eax, edi
            //   83c208               | add                 edx, 8
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   89c5                 | mov                 ebp, eax
            //   89c8                 | mov                 eax, ecx
            //   25ffffff3f           | and                 eax, 0x3fffffff

    condition:
        7 of them and filesize < 1238016
}