rule win_nitlove_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nitlove."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nitlove"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 6a0b 59 be???????? 8d7dc8 f3a5 b902000080 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   6a0b                 | push                0xb
            //   59                   | pop                 ecx
            //   be????????           |                     
            //   8d7dc8               | lea                 edi, [ebp - 0x38]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   b902000080           | mov                 ecx, 0x80000002

        $sequence_1 = { 03f0 c1e007 33f0 42 3bd7 7ce9 33c0 }
            // n = 7, score = 200
            //   03f0                 | add                 esi, eax
            //   c1e007               | shl                 eax, 7
            //   33f0                 | xor                 esi, eax
            //   42                   | inc                 edx
            //   3bd7                 | cmp                 edx, edi
            //   7ce9                 | jl                  0xffffffeb
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { b359 51 8d857cffffff 50 51 }
            // n = 5, score = 200
            //   b359                 | mov                 bl, 0x59
            //   51                   | push                ecx
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_3 = { 6a00 6aff ffd0 bab2bb282b 8bcb }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6aff                 | push                -1
            //   ffd0                 | call                eax
            //   bab2bb282b           | mov                 edx, 0x2b28bbb2
            //   8bcb                 | mov                 ecx, ebx

        $sequence_4 = { 6aff ffd7 0fb785dcfeffff 33c9 ba1e3d0000 66898c0504feffff }
            // n = 6, score = 200
            //   6aff                 | push                -1
            //   ffd7                 | call                edi
            //   0fb785dcfeffff       | movzx               eax, word ptr [ebp - 0x124]
            //   33c9                 | xor                 ecx, ecx
            //   ba1e3d0000           | mov                 edx, 0x3d1e
            //   66898c0504feffff     | mov                 word ptr [ebp + eax - 0x1fc], cx

        $sequence_5 = { ba4d8a978a 8bcb e8???????? ffd0 51 }
            // n = 5, score = 200
            //   ba4d8a978a           | mov                 edx, 0x8a978a4d
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   ffd0                 | call                eax
            //   51                   | push                ecx

        $sequence_6 = { 56 57 83ceff 33ff 8bd9 85d2 7e21 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   83ceff               | or                  esi, 0xffffffff
            //   33ff                 | xor                 edi, edi
            //   8bd9                 | mov                 ebx, ecx
            //   85d2                 | test                edx, edx
            //   7e21                 | jle                 0x23

        $sequence_7 = { 6a05 ffd6 833b00 747a 33db }
            // n = 5, score = 200
            //   6a05                 | push                5
            //   ffd6                 | call                esi
            //   833b00               | cmp                 dword ptr [ebx], 0
            //   747a                 | je                  0x7c
            //   33db                 | xor                 ebx, ebx

        $sequence_8 = { e8???????? 8b45ec 83c43c 5f }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   83c43c               | add                 esp, 0x3c
            //   5f                   | pop                 edi

        $sequence_9 = { 33f6 8b45f0 0345e4 8b4dd4 }
            // n = 4, score = 200
            //   33f6                 | xor                 esi, esi
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0345e4               | add                 eax, dword ptr [ebp - 0x1c]
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]

    condition:
        7 of them and filesize < 49152
}