rule win_nokki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nokki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nokki"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 33d2 68ce070000 52 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   68ce070000           | push                0x7ce
            //   52                   | push                edx

        $sequence_1 = { e8???????? 33c9 68ce070000 51 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   68ce070000           | push                0x7ce
            //   51                   | push                ecx

        $sequence_2 = { a1???????? a3???????? a1???????? c705????????b7634000 }
            // n = 4, score = 100
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????b7634000     |     

        $sequence_3 = { 8b550c 83c41c 6a00 6880000000 }
            // n = 4, score = 100
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   83c41c               | add                 esp, 0x1c
            //   6a00                 | push                0
            //   6880000000           | push                0x80

        $sequence_4 = { 8945ca 8945ce 668945d2 e8???????? 33c0 8945d6 8945da }
            // n = 7, score = 100
            //   8945ca               | mov                 dword ptr [ebp - 0x36], eax
            //   8945ce               | mov                 dword ptr [ebp - 0x32], eax
            //   668945d2             | mov                 word ptr [ebp - 0x2e], ax
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8945d6               | mov                 dword ptr [ebp - 0x2a], eax
            //   8945da               | mov                 dword ptr [ebp - 0x26], eax

        $sequence_5 = { c745ec5c374000 894df8 8945fc 64a100000000 8945e8 8d45e8 }
            // n = 6, score = 100
            //   c745ec5c374000       | mov                 dword ptr [ebp - 0x14], 0x40375c
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_6 = { 51 52 ff15???????? 85c0 0f85b1010000 8b957ce8ffff }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85b1010000         | jne                 0x1b7
            //   8b957ce8ffff         | mov                 edx, dword ptr [ebp - 0x1784]

        $sequence_7 = { 8d8db4f7ffff 51 68???????? 56 ffd3 }
            // n = 5, score = 100
            //   8d8db4f7ffff         | lea                 ecx, [ebp - 0x84c]
            //   51                   | push                ecx
            //   68????????           |                     
            //   56                   | push                esi
            //   ffd3                 | call                ebx

        $sequence_8 = { e8???????? 33c0 8d4dac 51 668945ac 8945ae }
            // n = 6, score = 100
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   51                   | push                ecx
            //   668945ac             | mov                 word ptr [ebp - 0x54], ax
            //   8945ae               | mov                 dword ptr [ebp - 0x52], eax

        $sequence_9 = { e8???????? 83c404 8bf0 8d850cf8ffff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bf0                 | mov                 esi, eax
            //   8d850cf8ffff         | lea                 eax, [ebp - 0x7f4]

        $sequence_10 = { 68???????? eb10 6a0b 68???????? eb07 6a0d }
            // n = 6, score = 100
            //   68????????           |                     
            //   eb10                 | jmp                 0x12
            //   6a0b                 | push                0xb
            //   68????????           |                     
            //   eb07                 | jmp                 9
            //   6a0d                 | push                0xd

        $sequence_11 = { 83c40c 6bc930 8975e0 8db1a0e94000 8975e4 eb2b }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db1a0e94000         | lea                 esi, [ecx + 0x40e9a0]
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   eb2b                 | jmp                 0x2d

        $sequence_12 = { 888888e84000 40 ebe6 ff35???????? }
            // n = 4, score = 100
            //   888888e84000         | mov                 byte ptr [eax + 0x40e888], cl
            //   40                   | inc                 eax
            //   ebe6                 | jmp                 0xffffffe8
            //   ff35????????         |                     

        $sequence_13 = { e8???????? ebde 8bc8 83e01f c1f905 8b0c8d80054100 c1e006 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ebde                 | jmp                 0xffffffe0
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d80054100       | mov                 ecx, dword ptr [ecx*4 + 0x410580]
            //   c1e006               | shl                 eax, 6

    condition:
        7 of them and filesize < 454656
}