rule win_nosu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nosu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nosu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8455010000 8d442438 50 8d442424 50 6a02 6a01 }
            // n = 7, score = 200
            //   0f8455010000         | je                  0x15b
            //   8d442438             | lea                 eax, [esp + 0x38]
            //   50                   | push                eax
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax
            //   6a02                 | push                2
            //   6a01                 | push                1

        $sequence_1 = { 50 6a00 8d54246c e8???????? 83c40c 84c0 0f8477020000 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8d54246c             | lea                 edx, [esp + 0x6c]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   84c0                 | test                al, al
            //   0f8477020000         | je                  0x27d

        $sequence_2 = { 33d2 8bcb ff742420 55 56 ff74242c 56 }
            // n = 7, score = 200
            //   33d2                 | xor                 edx, edx
            //   8bcb                 | mov                 ecx, ebx
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   55                   | push                ebp
            //   56                   | push                esi
            //   ff74242c             | push                dword ptr [esp + 0x2c]
            //   56                   | push                esi

        $sequence_3 = { 8844240a 84c0 7416 b201 8bce e8???????? 8b4514 }
            // n = 7, score = 200
            //   8844240a             | mov                 byte ptr [esp + 0xa], al
            //   84c0                 | test                al, al
            //   7416                 | je                  0x18
            //   b201                 | mov                 dl, 1
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_4 = { 399688010000 7432 3996d8050000 742a 8b8ef8070000 ff7514 }
            // n = 6, score = 200
            //   399688010000         | cmp                 dword ptr [esi + 0x188], edx
            //   7432                 | je                  0x34
            //   3996d8050000         | cmp                 dword ptr [esi + 0x5d8], edx
            //   742a                 | je                  0x2c
            //   8b8ef8070000         | mov                 ecx, dword ptr [esi + 0x7f8]
            //   ff7514               | push                dword ptr [ebp + 0x14]

        $sequence_5 = { 8d86e0020000 85c0 740d 6a5c 59 }
            // n = 5, score = 200
            //   8d86e0020000         | lea                 eax, [esi + 0x2e0]
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   6a5c                 | push                0x5c
            //   59                   | pop                 ecx

        $sequence_6 = { 89b658080000 50 56 b201 8bcf e8???????? 83c414 }
            // n = 7, score = 200
            //   89b658080000         | mov                 dword ptr [esi + 0x858], esi
            //   50                   | push                eax
            //   56                   | push                esi
            //   b201                 | mov                 dl, 1
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_7 = { 83c520 55 6a08 ff15???????? 50 ff15???????? }
            // n = 6, score = 200
            //   83c520               | add                 ebp, 0x20
            //   55                   | push                ebp
            //   6a08                 | push                8
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_8 = { c9 c3 57 8bfa 3b4c2408 740d 8bd1 }
            // n = 7, score = 200
            //   c9                   | leave               
            //   c3                   | ret                 
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   3b4c2408             | cmp                 ecx, dword ptr [esp + 8]
            //   740d                 | je                  0xf
            //   8bd1                 | mov                 edx, ecx

        $sequence_9 = { 83c01e 03c7 0101 ff414c 8d4c2418 e8???????? 5f }
            // n = 7, score = 200
            //   83c01e               | add                 eax, 0x1e
            //   03c7                 | add                 eax, edi
            //   0101                 | add                 dword ptr [ecx], eax
            //   ff414c               | inc                 dword ptr [ecx + 0x4c]
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   e8????????           |                     
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 513024
}