rule win_noxplayer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.noxplayer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.noxplayer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 4883ec20 488b7968 488d05833a0300 488bd9 488901 4885ff }
            // n = 7, score = 100
            //   57                   | lea                 ebx, [esp + 0x70]
            //   4883ec20             | inc                 ebp
            //   488b7968             | xor                 ecx, ecx
            //   488d05833a0300       | dec                 eax
            //   488bd9               | mov                 ecx, edi
            //   488901               | inc                 esp
            //   4885ff               | mov                 dword ptr [ebp - 0x19], ebp

        $sequence_1 = { 33db 48391d???????? 488bf8 0f85d5000000 488d0d6fc70000 ff15???????? }
            // n = 6, score = 100
            //   33db                 | lea                 eax, [ebp + 0x20]
            //   48391d????????       |                     
            //   488bf8               | dec                 eax
            //   0f85d5000000         | mov                 dword ptr [esp + 0x60], eax
            //   488d0d6fc70000       | dec                 eax
            //   ff15????????         |                     

        $sequence_2 = { 488d15757f0200 48894c2420 4885c9 7419 483901 750f 488b4108 }
            // n = 7, score = 100
            //   488d15757f0200       | xor                 ecx, esp
            //   48894c2420           | test                eax, eax
            //   4885c9               | js                  0x73a
            //   7419                 | dec                 esp
            //   483901               | mov                 dword ptr [ebp + 8], esi
            //   750f                 | dec                 eax
            //   488b4108             | lea                 eax, [ebp + 8]

        $sequence_3 = { 488b742450 488bc3 4883c440 5b c3 488d542430 4533c9 }
            // n = 7, score = 100
            //   488b742450           | call                dword ptr [eax + 8]
            //   488bc3               | dec                 esp
            //   4883c440             | mov                 esi, eax
            //   5b                   | inc                 ecx
            //   c3                   | mov                 ecx, dword ptr [esp + 0x38]
            //   488d542430           | imul                ecx, esi
            //   4533c9               | dec                 eax

        $sequence_4 = { 49c7430801000000 8b530c 85d2 743e 660f1f440000 448d42ff 41d1f8 }
            // n = 7, score = 100
            //   49c7430801000000     | push                ebp
            //   8b530c               | inc                 ecx
            //   85d2                 | push                esi
            //   743e                 | inc                 ecx
            //   660f1f440000         | push                edi
            //   448d42ff             | dec                 eax
            //   41d1f8               | sub                 esp, 0x140

        $sequence_5 = { eb06 488bd8 488b00 80782900 74e8 483b5908 }
            // n = 6, score = 100
            //   eb06                 | lea                 ecx, [ebp + 0x480]
            //   488bd8               | jmp                 0xf6a
            //   488b00               | dec                 esp
            //   80782900             | lea                 eax, [0x304f3]
            //   74e8                 | mov                 edx, 0x64
            //   483b5908             | dec                 eax

        $sequence_6 = { 4c8be8 0fb6465c 84c0 0f8553040000 4533e4 488b4e50 e8???????? }
            // n = 7, score = 100
            //   4c8be8               | mov                 ecx, dword ptr [edi + 0x100]
            //   0fb6465c             | inc                 ecx
            //   84c0                 | mov                 ecx, eax
            //   0f8553040000         | inc                 ecx
            //   4533e4               | sub                 ecx, ecx
            //   488b4e50             | mov                 eax, ecx
            //   e8????????           |                     

        $sequence_7 = { 742b 488bcf e8???????? 483b3d???????? 741a 488d05354c0200 483bf8 }
            // n = 7, score = 100
            //   742b                 | mov                 dword ptr [ebp + 0xf00], eax
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   483b3d????????       |                     
            //   741a                 | mov                 ebx, ecx
            //   488d05354c0200       | dec                 eax
            //   483bf8               | mov                 dword ptr [esp + 0x58], ecx

        $sequence_8 = { 4c8d4204 e8???????? eb78 488b4f50 498bd4 488b01 ff5040 }
            // n = 7, score = 100
            //   4c8d4204             | mov                 dword ptr [esp + 0x40], eax
            //   e8????????           |                     
            //   eb78                 | inc                 esp
            //   488b4f50             | mov                 ecx, dword ptr [esp + 0x50]
            //   498bd4               | xor                 edi, edi
            //   488b01               | jmp                 0x438
            //   ff5040               | mov                 edx, dword ptr [esp + 0x50]

        $sequence_9 = { 41390424 745d 807b1d00 754a 488b4310 80781d00 7520 }
            // n = 7, score = 100
            //   41390424             | inc                 ecx
            //   745d                 | mov                 dword ptr [eax + 0x60], 3
            //   807b1d00             | dec                 esi
            //   754a                 | lea                 edx, [edx + ebp + 4]
            //   488b4310             | xor                 eax, eax
            //   80781d00             | dec                 eax
            //   7520                 | or                  ecx, 0xffffffff

    condition:
        7 of them and filesize < 742400
}