rule win_nspx30_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nspx30."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nspx30"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 66ab aa b06c }
            // n = 4, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b06c                 | mov                 al, 0x6c

        $sequence_1 = { 0f8418030000 8b8530e5ffff 8b0485384c0410 f644060480 0f8400030000 e8???????? }
            // n = 6, score = 100
            //   0f8418030000         | je                  0x31e
            //   8b8530e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad0]
            //   8b0485384c0410       | mov                 eax, dword ptr [eax*4 + 0x10044c38]
            //   f644060480           | test                byte ptr [esi + eax + 4], 0x80
            //   0f8400030000         | je                  0x306
            //   e8????????           |                     

        $sequence_2 = { 8903 c7831400080000000000 eb58 ff15???????? 8bc8 8b44240c }
            // n = 6, score = 100
            //   8903                 | mov                 dword ptr [ebx], eax
            //   c7831400080000000000     | mov    dword ptr [ebx + 0x80014], 0
            //   eb58                 | jmp                 0x5a
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_3 = { 6a04 6800100000 03c3 57 50 ff5508 }
            // n = 6, score = 100
            //   6a04                 | push                4
            //   6800100000           | push                0x1000
            //   03c3                 | add                 eax, ebx
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff5508               | call                dword ptr [ebp + 8]

        $sequence_4 = { 8bf0 85db 742e 85ff }
            // n = 4, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85db                 | test                ebx, ebx
            //   742e                 | je                  0x30
            //   85ff                 | test                edi, edi

        $sequence_5 = { 66c78424d80000007300 66c78424de0000006100 66c78424e20000006f00 66c78424e60000002100 66c78424ea0000006500 66c78424ec0000007700 66c78424ee0000003a00 }
            // n = 7, score = 100
            //   66c78424d80000007300     | mov    word ptr [esp + 0xd8], 0x73
            //   66c78424de0000006100     | mov    word ptr [esp + 0xde], 0x61
            //   66c78424e20000006f00     | mov    word ptr [esp + 0xe2], 0x6f
            //   66c78424e60000002100     | mov    word ptr [esp + 0xe6], 0x21
            //   66c78424ea0000006500     | mov    word ptr [esp + 0xea], 0x65
            //   66c78424ec0000007700     | mov    word ptr [esp + 0xec], 0x77
            //   66c78424ee0000003a00     | mov    word ptr [esp + 0xee], 0x3a

        $sequence_6 = { 8b45f8 50 e8???????? 8945a8 688e4e0eec }
            // n = 5, score = 100
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945a8               | mov                 dword ptr [ebp - 0x58], eax
            //   688e4e0eec           | push                0xec0e4e8e

        $sequence_7 = { 6689b4249c000000 52 be32000000 6a00 51 66c74424787b00 66c744247a3300 }
            // n = 7, score = 100
            //   6689b4249c000000     | mov                 word ptr [esp + 0x9c], si
            //   52                   | push                edx
            //   be32000000           | mov                 esi, 0x32
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   66c74424787b00       | mov                 word ptr [esp + 0x78], 0x7b
            //   66c744247a3300       | mov                 word ptr [esp + 0x7a], 0x33

        $sequence_8 = { 0f8c89010000 8b4c2410 8b11 8b420c 8b7a08 }
            // n = 5, score = 100
            //   0f8c89010000         | jl                  0x18f
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b420c               | mov                 eax, dword ptr [edx + 0xc]
            //   8b7a08               | mov                 edi, dword ptr [edx + 8]

        $sequence_9 = { 33c0 e9???????? 8b550c 52 6a14 e8???????? }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx
            //   6a14                 | push                0x14
            //   e8????????           |                     

        $sequence_10 = { 5e 7426 40 c60057 40 c60049 40 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   7426                 | je                  0x28
            //   40                   | inc                 eax
            //   c60057               | mov                 byte ptr [eax], 0x57
            //   40                   | inc                 eax
            //   c60049               | mov                 byte ptr [eax], 0x49
            //   40                   | inc                 eax

        $sequence_11 = { 833800 0f8494010000 ff750c ff7508 e8???????? 8bf0 }
            // n = 6, score = 100
            //   833800               | cmp                 dword ptr [eax], 0
            //   0f8494010000         | je                  0x19a
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_12 = { 8b44240c 85c0 7460 53 ba04000000 }
            // n = 5, score = 100
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   85c0                 | test                eax, eax
            //   7460                 | je                  0x62
            //   53                   | push                ebx
            //   ba04000000           | mov                 edx, 4

        $sequence_13 = { e8???????? 8b0f 8bc1 c1f805 83e11f 8b0485384c0410 c1e106 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   8bc1                 | mov                 eax, ecx
            //   c1f805               | sar                 eax, 5
            //   83e11f               | and                 ecx, 0x1f
            //   8b0485384c0410       | mov                 eax, dword ptr [eax*4 + 0x10044c38]
            //   c1e106               | shl                 ecx, 6

        $sequence_14 = { 83ec0c 53 8b5c2414 56 57 6a01 }
            // n = 6, score = 100
            //   83ec0c               | sub                 esp, 0xc
            //   53                   | push                ebx
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a01                 | push                1

        $sequence_15 = { b843000000 66898c24c0000000 66898c24ce000000 66898c24d2000000 }
            // n = 4, score = 100
            //   b843000000           | mov                 eax, 0x43
            //   66898c24c0000000     | mov                 word ptr [esp + 0xc0], cx
            //   66898c24ce000000     | mov                 word ptr [esp + 0xce], cx
            //   66898c24d2000000     | mov                 word ptr [esp + 0xd2], cx

        $sequence_16 = { 6689bc24fe000000 6689bc2400010000 6689b42402010000 66c78424040100004500 66c78424080100003300 66c784240a0100004500 }
            // n = 6, score = 100
            //   6689bc24fe000000     | mov                 word ptr [esp + 0xfe], di
            //   6689bc2400010000     | mov                 word ptr [esp + 0x100], di
            //   6689b42402010000     | mov                 word ptr [esp + 0x102], si
            //   66c78424040100004500     | mov    word ptr [esp + 0x104], 0x45
            //   66c78424080100003300     | mov    word ptr [esp + 0x108], 0x33
            //   66c784240a0100004500     | mov    word ptr [esp + 0x10a], 0x45

        $sequence_17 = { 6689444ffe 3bcb 72e7 e9???????? 8b7c2418 33c9 85db }
            // n = 7, score = 100
            //   6689444ffe           | mov                 word ptr [edi + ecx*2 - 2], ax
            //   3bcb                 | cmp                 ecx, ebx
            //   72e7                 | jb                  0xffffffe9
            //   e9????????           |                     
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   33c9                 | xor                 ecx, ecx
            //   85db                 | test                ebx, ebx

        $sequence_18 = { bf???????? 83c9ff 33c0 6a5c }
            // n = 4, score = 100
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   6a5c                 | push                0x5c

        $sequence_19 = { 8b0495384c0410 83c702 ff3418 ff15???????? 85c0 750e ff15???????? }
            // n = 7, score = 100
            //   8b0495384c0410       | mov                 eax, dword ptr [edx*4 + 0x10044c38]
            //   83c702               | add                 edi, 2
            //   ff3418               | push                dword ptr [eax + ebx]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750e                 | jne                 0x10
            //   ff15????????         |                     

        $sequence_20 = { 894dfc 8b55fc 8b4508 034220 8945ec }
            // n = 5, score = 100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   034220               | add                 eax, dword ptr [edx + 0x20]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_21 = { 8b1481 8955d8 8b4508 0345d8 eb04 eba4 }
            // n = 6, score = 100
            //   8b1481               | mov                 edx, dword ptr [ecx + eax*4]
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345d8               | add                 eax, dword ptr [ebp - 0x28]
            //   eb04                 | jmp                 6
            //   eba4                 | jmp                 0xffffffa6

        $sequence_22 = { ffd2 c7461000000000 8b4608 53 8b5c2410 85c0 }
            // n = 6, score = 100
            //   ffd2                 | call                edx
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   53                   | push                ebx
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   85c0                 | test                eax, eax

        $sequence_23 = { 83c404 c745fcffffffff 833d????????00 8b07 }
            // n = 4, score = 100
            //   83c404               | add                 esp, 4
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   833d????????00       |                     
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_24 = { c7402420120010 c7402860120010 33c0 5e c20800 6879270000 ff15???????? }
            // n = 7, score = 100
            //   c7402420120010       | mov                 dword ptr [eax + 0x24], 0x10001220
            //   c7402860120010       | mov                 dword ptr [eax + 0x28], 0x10001260
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   c20800               | ret                 8
            //   6879270000           | push                0x2779
            //   ff15????????         |                     

        $sequence_25 = { b801000000 5b 81c410030000 c20c00 5f 5e }
            // n = 6, score = 100
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   81c410030000         | add                 esp, 0x310
            //   c20c00               | ret                 0xc
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_26 = { 5b 754a c7002c000000 895004 895008 c7400ca0120010 }
            // n = 6, score = 100
            //   5b                   | pop                 ebx
            //   754a                 | jne                 0x4c
            //   c7002c000000         | mov                 dword ptr [eax], 0x2c
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   c7400ca0120010       | mov                 dword ptr [eax + 0xc], 0x100012a0

        $sequence_27 = { 83c9ff 33c0 c644240c57 c644240d69 c644240e6e c644240f64 c64424106f }
            // n = 7, score = 100
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   c644240c57           | mov                 byte ptr [esp + 0xc], 0x57
            //   c644240d69           | mov                 byte ptr [esp + 0xd], 0x69
            //   c644240e6e           | mov                 byte ptr [esp + 0xe], 0x6e
            //   c644240f64           | mov                 byte ptr [esp + 0xf], 0x64
            //   c64424106f           | mov                 byte ptr [esp + 0x10], 0x6f

        $sequence_28 = { 6a00 ff15???????? 8bfb 83c9ff 33c0 b25c f2ae }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bfb                 | mov                 edi, ebx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   b25c                 | mov                 dl, 0x5c
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_29 = { 7c86 5f 5d 5e 5b }
            // n = 5, score = 100
            //   7c86                 | jl                  0xffffff88
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_30 = { 57 66896c2436 66896c2446 8d4c2414 bb38000000 be2d000000 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   66896c2436           | mov                 word ptr [esp + 0x36], bp
            //   66896c2446           | mov                 word ptr [esp + 0x46], bp
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   bb38000000           | mov                 ebx, 0x38
            //   be2d000000           | mov                 esi, 0x2d

    condition:
        7 of them and filesize < 3789824
}