rule win_ntospy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ntospy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ntospy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5f c3 48897c2408 488d3dacf90000 }
            // n = 4, score = 100
            //   5f                   | dec                 eax
            //   c3                   | mov                 eax, dword ptr [esp + 0x28]
            //   48897c2408           | dec                 eax
            //   488d3dacf90000       | lea                 ecx, [0x71fb]

        $sequence_1 = { eb74 85c9 7858 3b15???????? 7350 488bca 4c8d05e5b40000 }
            // n = 7, score = 100
            //   eb74                 | cmp                 ecx, -3
            //   85c9                 | ja                  0x502
            //   7858                 | dec                 eax
            //   3b15????????         |                     
            //   7350                 | and                 dword ptr [esp + 0x30], 0
            //   488bca               | dec                 eax
            //   4c8d05e5b40000       | lea                 ecx, [0x714c]

        $sequence_2 = { 8bfa 4c8d0d5d740000 488bd9 488d1553740000 b916000000 4c8d053f740000 e8???????? }
            // n = 7, score = 100
            //   8bfa                 | lea                 edx, [ecx + ecx*8]
            //   4c8d0d5d740000       | dec                 ecx
            //   488bd9               | mov                 eax, dword ptr [eax + eax*8]
            //   488d1553740000       | dec                 eax
            //   b916000000           | arpl                si, cx
            //   4c8d053f740000       | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { b808000000 486bc000 488d0deaad0000 48c7040102000000 b808000000 }
            // n = 5, score = 100
            //   b808000000           | sub                 esp, 0x20
            //   486bc000             | dec                 eax
            //   488d0deaad0000       | lea                 ebx, [0x11e7b]
            //   48c7040102000000     | dec                 eax
            //   b808000000           | lea                 edi, [0x11e74]

        $sequence_4 = { 48890d???????? 488d0512f50000 488d0d3bf70000 488905???????? 48890d???????? e8???????? }
            // n = 6, score = 100
            //   48890d????????       |                     
            //   488d0512f50000       | jle                 0x10f7
            //   488d0d3bf70000       | dec                 esp
            //   488905????????       |                     
            //   48890d????????       |                     
            //   e8????????           |                     

        $sequence_5 = { 4c8d0578760000 488d15016d0000 e8???????? 4885c0 740f 488bcb }
            // n = 6, score = 100
            //   4c8d0578760000       | mov                 eax, edx
            //   488d15016d0000       | mov                 ecx, eax
            //   e8????????           |                     
            //   4885c0               | int                 0x29
            //   740f                 | dec                 eax
            //   488bcb               | lea                 ecx, [0xadeb]

        $sequence_6 = { f20f1000 8b5808 e9???????? 488d05dfc70000 4a8b0ce8 }
            // n = 5, score = 100
            //   f20f1000             | mov                 edx, eax
            //   8b5808               | dec                 eax
            //   e9????????           |                     
            //   488d05dfc70000       | ror                 edx, cl
            //   4a8b0ce8             | dec                 ecx

        $sequence_7 = { 488d0d4c710000 8364242800 41b803000000 4533c9 }
            // n = 4, score = 100
            //   488d0d4c710000       | jle                 0x109
            //   8364242800           | dec                 ebx
            //   41b803000000         | mov                 eax, dword ptr [edi + 0x161e0]
            //   4533c9               | dec                 esp

        $sequence_8 = { c3 4883ec28 e8???????? 488bc8 488d1501040100 }
            // n = 5, score = 100
            //   c3                   | dec                 eax
            //   4883ec28             | mov                 dword ptr [esp + 8], edi
            //   e8????????           |                     
            //   488bc8               | dec                 eax
            //   488d1501040100       | lea                 edi, [0xf9ac]

        $sequence_9 = { 4533f6 4863ce 488d3d20f90000 488bc1 }
            // n = 4, score = 100
            //   4533f6               | mov                 eax, dword ptr [edi + esi*8 + 0x10258]
            //   4863ce               | test                eax, eax
            //   488d3d20f90000       | js                  0x36
            //   488bc1               | cmp                 eax, 0xe4

    condition:
        7 of them and filesize < 208896
}