rule win_nvisospit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nvisospit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nvisospit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f807 7ea8 83f80b 8b15???????? 0f8e16010000 85d2 0f8493010000 }
            // n = 7, score = 100
            //   83f807               | cmp                 eax, 7
            //   7ea8                 | jle                 0xffffffaa
            //   83f80b               | cmp                 eax, 0xb
            //   8b15????????         |                     
            //   0f8e16010000         | jle                 0x11c
            //   85d2                 | test                edx, edx
            //   0f8493010000         | je                  0x199

        $sequence_1 = { 0f8598000000 8b15???????? b9???????? e9???????? 0fb60f 89cb }
            // n = 6, score = 100
            //   0f8598000000         | jne                 0x9e
            //   8b15????????         |                     
            //   b9????????           |                     
            //   e9????????           |                     
            //   0fb60f               | movzx               ecx, byte ptr [edi]
            //   89cb                 | mov                 ebx, ecx

        $sequence_2 = { 3b5dc4 89b700004000 89da 75d8 }
            // n = 4, score = 100
            //   3b5dc4               | cmp                 ebx, dword ptr [ebp - 0x3c]
            //   89b700004000         | mov                 dword ptr [edi + 0x400000], esi
            //   89da                 | mov                 edx, ebx
            //   75d8                 | jne                 0xffffffda

        $sequence_3 = { 8b00 89442404 c70424???????? e8???????? 8b859cf9ffff 0fb74004 0fb7c0 }
            // n = 7, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c70424????????       |                     
            //   e8????????           |                     
            //   8b859cf9ffff         | mov                 eax, dword ptr [ebp - 0x664]
            //   0fb74004             | movzx               eax, word ptr [eax + 4]
            //   0fb7c0               | movzx               eax, ax

        $sequence_4 = { 8d7600 8dbc2700000000 b9???????? 85d2 0f85eafeffff 8b7104 }
            // n = 6, score = 100
            //   8d7600               | lea                 esi, [esi]
            //   8dbc2700000000       | lea                 edi, [edi]
            //   b9????????           |                     
            //   85d2                 | test                edx, edx
            //   0f85eafeffff         | jne                 0xfffffef0
            //   8b7104               | mov                 esi, dword ptr [ecx + 4]

        $sequence_5 = { 83c308 8b7a04 8b12 039700004000 8d8700004000 89d6 e8???????? }
            // n = 7, score = 100
            //   83c308               | add                 ebx, 8
            //   8b7a04               | mov                 edi, dword ptr [edx + 4]
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   039700004000         | add                 edx, dword ptr [edi + 0x400000]
            //   8d8700004000         | lea                 eax, [edi + 0x400000]
            //   89d6                 | mov                 esi, edx
            //   e8????????           |                     

        $sequence_6 = { 89742410 894c240c 89542408 89442404 c70424???????? }
            // n = 5, score = 100
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   894c240c             | mov                 dword ptr [esp + 0xc], ecx
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c70424????????       |                     

        $sequence_7 = { 8b35???????? 85f6 0f8ef0000000 8b3d???????? }
            // n = 4, score = 100
            //   8b35????????         |                     
            //   85f6                 | test                esi, esi
            //   0f8ef0000000         | jle                 0xf6
            //   8b3d????????         |                     

        $sequence_8 = { b9???????? e9???????? 0fb60f 89cb 81cb00ffffff }
            // n = 5, score = 100
            //   b9????????           |                     
            //   e9????????           |                     
            //   0fb60f               | movzx               ecx, byte ptr [edi]
            //   89cb                 | mov                 ebx, ecx
            //   81cb00ffffff         | or                  ebx, 0xffffff00

        $sequence_9 = { 89c3 89f8 e8???????? 891f ebcc 0fb79900004000 }
            // n = 6, score = 100
            //   89c3                 | mov                 ebx, eax
            //   89f8                 | mov                 eax, edi
            //   e8????????           |                     
            //   891f                 | mov                 dword ptr [edi], ebx
            //   ebcc                 | jmp                 0xffffffce
            //   0fb79900004000       | movzx               ebx, word ptr [ecx + 0x400000]

    condition:
        7 of them and filesize < 66560
}