rule win_nymaim2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nymaim2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nymaim2"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf9 be???????? 56 8d5f14 e8???????? 59 }
            // n = 6, score = 200
            //   8bf9                 | mov                 edi, ecx
            //   be????????           |                     
            //   56                   | push                esi
            //   8d5f14               | lea                 ebx, [edi + 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_1 = { 33c0 eb07 8b07 8b4004 03c7 83480c04 8b07 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   eb07                 | jmp                 9
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   03c7                 | add                 eax, edi
            //   83480c04             | or                  dword ptr [eax + 0xc], 4
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_2 = { ff5008 51 8d4604 8bcc 896508 50 e8???????? }
            // n = 7, score = 200
            //   ff5008               | call                dword ptr [eax + 8]
            //   51                   | push                ecx
            //   8d4604               | lea                 eax, [esi + 4]
            //   8bcc                 | mov                 ecx, esp
            //   896508               | mov                 dword ptr [ebp + 8], esp
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 5b c1f805 d3e3 8d0486 0918 8b45e8 8b5df0 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   c1f805               | sar                 eax, 5
            //   d3e3                 | shl                 ebx, cl
            //   8d0486               | lea                 eax, [esi + eax*4]
            //   0918                 | or                  dword ptr [eax], ebx
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]

        $sequence_4 = { ff4008 8b06 397808 75c2 ff400c ebbd 8b5620 }
            // n = 7, score = 200
            //   ff4008               | inc                 dword ptr [eax + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   397808               | cmp                 dword ptr [eax + 8], edi
            //   75c2                 | jne                 0xffffffc4
            //   ff400c               | inc                 dword ptr [eax + 0xc]
            //   ebbd                 | jmp                 0xffffffbf
            //   8b5620               | mov                 edx, dword ptr [esi + 0x20]

        $sequence_5 = { 885dfc e8???????? 8d4e24 e8???????? 83ec18 8bcc 8965ec }
            // n = 7, score = 200
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   e8????????           |                     
            //   8d4e24               | lea                 ecx, [esi + 0x24]
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18
            //   8bcc                 | mov                 ecx, esp
            //   8965ec               | mov                 dword ptr [ebp - 0x14], esp

        $sequence_6 = { 8d45e4 53 50 ff15???????? 6a01 8d4de4 c645fc02 }
            // n = 7, score = 200
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2

        $sequence_7 = { 51 56 8bf1 8975f0 c706???????? 8d4e64 c745fc04000000 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   c706????????         |                     
            //   8d4e64               | lea                 ecx, [esi + 0x64]
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4

        $sequence_8 = { 8b00 23c7 3b02 894514 7d58 8b5508 8d1482 }
            // n = 7, score = 200
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   23c7                 | and                 eax, edi
            //   3b02                 | cmp                 eax, dword ptr [edx]
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   7d58                 | jge                 0x5a
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8d1482               | lea                 edx, [edx + eax*4]

        $sequence_9 = { e8???????? 50 8d4d08 e8???????? 85c0 0f9dc3 8d4d9c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f9dc3               | setge               bl
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]

    condition:
        7 of them and filesize < 753664
}