rule win_nymaim_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nymaim."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nymaim"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89d8 01c8 31d2 f7f7 }
            // n = 4, score = 1800
            //   89d8                 | mov                 eax, ebx
            //   01c8                 | add                 eax, ecx
            //   31d2                 | xor                 edx, edx
            //   f7f7                 | div                 edi

        $sequence_1 = { f7f7 92 31d2 bf64000000 }
            // n = 4, score = 1700
            //   f7f7                 | div                 edi
            //   92                   | xchg                eax, edx
            //   31d2                 | xor                 edx, edx
            //   bf64000000           | mov                 edi, 0x64

        $sequence_2 = { 0f94c1 09c8 6bc064 09c0 }
            // n = 4, score = 1700
            //   0f94c1               | sete                cl
            //   09c8                 | or                  eax, ecx
            //   6bc064               | imul                eax, eax, 0x64
            //   09c0                 | or                  eax, eax

        $sequence_3 = { 38f0 83d100 38d0 83d900 }
            // n = 4, score = 1600
            //   38f0                 | cmp                 al, dh
            //   83d100               | adc                 ecx, 0
            //   38d0                 | cmp                 al, dl
            //   83d900               | sbb                 ecx, 0

        $sequence_4 = { 010d???????? 8b1d???????? 011d???????? c1eb13 }
            // n = 4, score = 1600
            //   010d????????         |                     
            //   8b1d????????         |                     
            //   011d????????         |                     
            //   c1eb13               | shr                 ebx, 0x13

        $sequence_5 = { c1eb13 331d???????? 31c3 c1e808 }
            // n = 4, score = 1600
            //   c1eb13               | shr                 ebx, 0x13
            //   331d????????         |                     
            //   31c3                 | xor                 ebx, eax
            //   c1e808               | shr                 eax, 8

        $sequence_6 = { 31c3 891d???????? 89d8 01c8 }
            // n = 4, score = 1600
            //   31c3                 | xor                 ebx, eax
            //   891d????????         |                     
            //   89d8                 | mov                 eax, ebx
            //   01c8                 | add                 eax, ecx

        $sequence_7 = { 31d2 bf64000000 f7f7 5b }
            // n = 4, score = 1600
            //   31d2                 | xor                 edx, edx
            //   bf64000000           | mov                 edi, 0x64
            //   f7f7                 | div                 edi
            //   5b                   | pop                 ebx

        $sequence_8 = { 38d0 83d900 c1e105 01c8 }
            // n = 4, score = 1600
            //   38d0                 | cmp                 al, dl
            //   83d900               | sbb                 ecx, 0
            //   c1e105               | shl                 ecx, 5
            //   01c8                 | add                 eax, ecx

        $sequence_9 = { 00d3 8a16 301e 46 01fb }
            // n = 5, score = 1300
            //   00d3                 | add                 bl, dl
            //   8a16                 | mov                 dl, byte ptr [esi]
            //   301e                 | xor                 byte ptr [esi], bl
            //   46                   | inc                 esi
            //   01fb                 | add                 ebx, edi

        $sequence_10 = { c1e808 31c3 895e0c 89d8 }
            // n = 4, score = 1100
            //   c1e808               | shr                 eax, 8
            //   31c3                 | xor                 ebx, eax
            //   895e0c               | mov                 dword ptr [esi + 0xc], ebx
            //   89d8                 | mov                 eax, ebx

        $sequence_11 = { 8b5604 0116 8b4e08 014e04 8b5e0c }
            // n = 5, score = 1100
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   0116                 | add                 dword ptr [esi], edx
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   014e04               | add                 dword ptr [esi + 4], ecx
            //   8b5e0c               | mov                 ebx, dword ptr [esi + 0xc]

        $sequence_12 = { 8b5d18 8b1b 4f 31c0 fec2 }
            // n = 5, score = 1100
            //   8b5d18               | mov                 ebx, dword ptr [ebp + 0x18]
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   4f                   | dec                 edi
            //   31c0                 | xor                 eax, eax
            //   fec2                 | inc                 dl

        $sequence_13 = { f7e0 0fc8 01d0 894704 }
            // n = 4, score = 1100
            //   f7e0                 | mul                 eax
            //   0fc8                 | bswap               eax
            //   01d0                 | add                 eax, edx
            //   894704               | mov                 dword ptr [edi + 4], eax

        $sequence_14 = { 8b5514 8b12 8b4d0c 8b5d18 }
            // n = 4, score = 1100
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5d18               | mov                 ebx, dword ptr [ebp + 0x18]

        $sequence_15 = { 31c9 8b55f4 8b75ec 89723c c7424003000000 }
            // n = 5, score = 100
            //   31c9                 | xor                 ecx, ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b75ec               | mov                 esi, dword ptr [ebp - 0x14]
            //   89723c               | mov                 dword ptr [edx + 0x3c], esi
            //   c7424003000000       | mov                 dword ptr [edx + 0x40], 3

        $sequence_16 = { 56 83ec28 8b450c 8b4d08 8d154e30d201 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   83ec28               | sub                 esp, 0x28
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d154e30d201         | lea                 edx, [0x1d2304e]

        $sequence_17 = { 83ec44 8b4508 8d0d2030d201 31d2 890c24 c744240400000000 }
            // n = 6, score = 100
            //   83ec44               | sub                 esp, 0x44
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d0d2030d201         | lea                 ecx, [0x1d23020]
            //   31d2                 | xor                 edx, edx
            //   890c24               | mov                 dword ptr [esp], ecx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_18 = { 890424 894c2404 e8???????? 8d0d3430d201 }
            // n = 4, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   e8????????           |                     
            //   8d0d3430d201         | lea                 ecx, [0x1d23034]

        $sequence_19 = { 5b 5d c3 8b45f0 8b0c850440d201 }
            // n = 5, score = 100
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b0c850440d201       | mov                 ecx, dword ptr [eax*4 + 0x1d24004]

        $sequence_20 = { 53 56 57 83ec44 8b4508 8d0d2030d201 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   83ec44               | sub                 esp, 0x44
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d0d2030d201         | lea                 ecx, [0x1d23020]

        $sequence_21 = { 31d2 890c24 c744240400000000 8945f4 8955f0 e8???????? 8d0d8630d201 }
            // n = 7, score = 100
            //   31d2                 | xor                 edx, edx
            //   890c24               | mov                 dword ptr [esp], ecx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   e8????????           |                     
            //   8d0d8630d201         | lea                 ecx, [0x1d23086]

        $sequence_22 = { 55 89e5 83ec10 8b4508 8d0d3430d201 }
            // n = 5, score = 100
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d0d3430d201         | lea                 ecx, [0x1d23034]

    condition:
        1 of them and filesize < 2375680
}