rule win_oatboat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.oatboat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oatboat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745e465655669 c745e872747561 c745ec6c4d656d c745f06f727900 e8???????? 41b900800000 }
            // n = 6, score = 100
            //   c745e465655669       | dec                 eax
            //   c745e872747561       | lea                 edx, [ebp + 0x48]
            //   c745ec6c4d656d       | dec                 eax
            //   c745f06f727900       | or                  ecx, 0xffffffff
            //   e8????????           |                     
            //   41b900800000         | call                eax

        $sequence_1 = { 488d0dc20b0000 ff15???????? 33c0 4883c450 415f }
            // n = 5, score = 100
            //   488d0dc20b0000       | xor                 ebx, ebx
            //   ff15????????         |                     
            //   33c0                 | mov                 dword ptr [ebp - 0x1c], 0x4e0052
            //   4883c450             | jne                 0x9f
            //   415f                 | dec                 ecx

        $sequence_2 = { 4c896538 c745e04e74416c c745e46c6f6361 c745e874655669 c745ec72747561 c745f06c4d656d c745f46f727900 }
            // n = 7, score = 100
            //   4c896538             | je                  0x50
            //   c745e04e74416c       | dec                 esp
            //   c745e46c6f6361       | mov                 esi, edi
            //   c745e874655669       | dec                 esp
            //   c745ec72747561       | sub                 esi, ebx
            //   c745f06c4d656d       | movsx               edx, byte ptr [ebx]
            //   c745f46f727900       | movzx               ecx, al

        $sequence_3 = { c745e8656d6f72 66c745ec7900 e8???????? 4d8bc4 }
            // n = 4, score = 100
            //   c745e8656d6f72       | mov                 esi, edi
            //   66c745ec7900         | dec                 ebp
            //   e8????????           |                     
            //   4d8bc4               | test                ebx, ebx

        $sequence_4 = { c745ec72747561 c745f06c4d656d c745f46f727900 e8???????? 4c8d4d38 c744242840000000 4533c0 }
            // n = 7, score = 100
            //   c745ec72747561       | dec                 eax
            //   c745f06c4d656d       | lea                 ecx, [0xbc2]
            //   c745f46f727900       | inc                 edi
            //   e8????????           |                     
            //   4c8d4d38             | movsx               eax, byte ptr [edi + ebp]
            //   c744242840000000     | lea                 ecx, [edx - 0x41]
            //   4533c0               | cmp                 ecx, 0x19

        $sequence_5 = { 488bc8 e8???????? 488bd8 488b7c2458 488bc3 }
            // n = 5, score = 100
            //   488bc8               | dec                 eax
            //   e8????????           |                     
            //   488bd8               | sub                 esp, 0x40
            //   488b7c2458           | dec                 eax
            //   488bc3               | mov                 edi, ecx

        $sequence_6 = { 7527 488d4df0 c745f04c6f6164 c745f44c696272 c745f861727957 44887dfc e8???????? }
            // n = 7, score = 100
            //   7527                 | dec                 ecx
            //   488d4df0             | add                 eax, ebx
            //   c745f04c6f6164       | dec                 ecx
            //   c745f44c696272       | add                 ecx, ebx
            //   c745f861727957       | inc                 esp
            //   44887dfc             | movzx               eax, word ptr [edx + eax]
            //   e8????????           |                     

        $sequence_7 = { c745ec33003200 c745f02e004400 c745f44c004c00 e8???????? }
            // n = 4, score = 100
            //   c745ec33003200       | dec                 ecx
            //   c745f02e004400       | mov                 ecx, edi
            //   c745f44c004c00       | call                ebx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 58368
}