rule win_observer_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.observer_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.observer_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 57 8bc8 e8???????? 6a14 89442418 e8???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   57                   | push                edi
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6a14                 | push                0x14
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   e8????????           |                     

        $sequence_1 = { 8bcb e8???????? e9???????? 85ff 74cc 68???????? 8d4c2418 }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   e9????????           |                     
            //   85ff                 | test                edi, edi
            //   74cc                 | je                  0xffffffce
            //   68????????           |                     
            //   8d4c2418             | lea                 ecx, [esp + 0x18]

        $sequence_2 = { c3 33c0 8bd1 53 56 57 8bfa }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   8bd1                 | mov                 edx, ecx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx

        $sequence_3 = { 59 59 c20400 56 8bf1 8b46e0 8b4004 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8b46e0               | mov                 eax, dword ptr [esi - 0x20]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_4 = { c3 83ec10 53 8bc1 55 }
            // n = 5, score = 100
            //   c3                   | ret                 
            //   83ec10               | sub                 esp, 0x10
            //   53                   | push                ebx
            //   8bc1                 | mov                 eax, ecx
            //   55                   | push                ebp

        $sequence_5 = { 55 e8???????? 3bc7 0f87ab000000 6bc024 50 89442414 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   e8????????           |                     
            //   3bc7                 | cmp                 eax, edi
            //   0f87ab000000         | ja                  0xb1
            //   6bc024               | imul                eax, eax, 0x24
            //   50                   | push                eax
            //   89442414             | mov                 dword ptr [esp + 0x14], eax

        $sequence_6 = { 8b751c 56 68???????? 57 e8???????? 8b4510 }
            // n = 6, score = 100
            //   8b751c               | mov                 esi, dword ptr [ebp + 0x1c]
            //   56                   | push                esi
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_7 = { 894d0c 894508 3d00100000 7215 8d4508 50 8d450c }
            // n = 7, score = 100
            //   894d0c               | mov                 dword ptr [ebp + 0xc], ecx
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   3d00100000           | cmp                 eax, 0x1000
            //   7215                 | jb                  0x17
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   8d450c               | lea                 eax, [ebp + 0xc]

        $sequence_8 = { 8d4dc0 68???????? e8???????? 837d3408 8d4d20 8d4508 0f434d20 }
            // n = 7, score = 100
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   68????????           |                     
            //   e8????????           |                     
            //   837d3408             | cmp                 dword ptr [ebp + 0x34], 8
            //   8d4d20               | lea                 ecx, [ebp + 0x20]
            //   8d4508               | lea                 eax, [ebp + 8]
            //   0f434d20             | cmovae              ecx, dword ptr [ebp + 0x20]

        $sequence_9 = { 89773c c7474001000000 c74750fb5d7708 e8???????? 8bc7 5f 5e }
            // n = 7, score = 100
            //   89773c               | mov                 dword ptr [edi + 0x3c], esi
            //   c7474001000000       | mov                 dword ptr [edi + 0x40], 1
            //   c74750fb5d7708       | mov                 dword ptr [edi + 0x50], 0x8775dfb
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 614400
}