rule win_oceansalt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.oceansalt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oceansalt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8b7508 57 6a00 6804020000 8d85f8f9ffff 50 }
            // n = 7, score = 300
            //   56                   | push                0
            //   8b7508               | push                edx
            //   57                   | push                edi
            //   6a00                 | push                eax
            //   6804020000           | test                ecx, ecx
            //   8d85f8f9ffff         | jle                 0x11
            //   50                   | xor                 byte ptr [ebp + eax - 0x204], 0x77

        $sequence_1 = { 0f8492000000 53 6a00 6a00 6a00 6802000008 }
            // n = 6, score = 300
            //   0f8492000000         | dec                 eax
            //   53                   | mov                 eax, dword ptr [ecx]
            //   6a00                 | jmp                 0x50
            //   6a00                 | dec                 eax
            //   6a00                 | lea                 edx, [esp + 0x34]
            //   6802000008           | jmp                 0x42

        $sequence_2 = { 50 56 ffd3 6a00 6880000000 6a02 }
            // n = 6, score = 300
            //   50                   | push                esi
            //   56                   | mov                 byte ptr [ebp - 0xc], 0
            //   ffd3                 | push                0
            //   6a00                 | je                  0x98
            //   6880000000           | push                ebx
            //   6a02                 | push                0

        $sequence_3 = { 8b4508 6a00 52 57 50 }
            // n = 5, score = 300
            //   8b4508               | xor                 eax, eax
            //   6a00                 | xor                 edx, edx
            //   52                   | repne scasb         al, byte ptr es:[edi]
            //   57                   | dec                 eax
            //   50                   | not                 ecx

        $sequence_4 = { 6a07 8d45f4 50 56 c645f400 ff15???????? 6a00 }
            // n = 7, score = 300
            //   6a07                 | inc                 eax
            //   8d45f4               | push                ebp
            //   50                   | dec                 eax
            //   56                   | sub                 esp, 0x20
            //   c645f400             | dec                 eax
            //   ff15????????         |                     
            //   6a00                 | mov                 ebp, edx

        $sequence_5 = { 85c9 7e0d 80b405fcfdffff77 40 3bc1 7cf3 56 }
            // n = 7, score = 300
            //   85c9                 | test                edi, edi
            //   7e0d                 | je                  0x40
            //   80b405fcfdffff77     | push                0
            //   40                   | push                esi
            //   3bc1                 | push                7
            //   7cf3                 | lea                 eax, [ebp - 0xc]
            //   56                   | push                eax

        $sequence_6 = { 85ff 743c 6a00 56 }
            // n = 4, score = 300
            //   85ff                 | dec                 eax
            //   743c                 | add                 esp, 0x40
            //   6a00                 | pop                 ebp
            //   56                   | ret                 

        $sequence_7 = { 83c404 85c0 75ce 8b8dc4fdffff }
            // n = 4, score = 300
            //   83c404               | inc                 eax
            //   85c0                 | cmp                 eax, ecx
            //   75ce                 | jl                  0
            //   8b8dc4fdffff         | push                esi

        $sequence_8 = { 8be8 85c0 0f841e010000 48899c24a8010000 }
            // n = 4, score = 100
            //   8be8                 | inc                 ecx
            //   85c0                 | cmp                 ch, dl
            //   0f841e010000         | jne                 0xfffff92d
            //   48899c24a8010000     | inc                 esp

        $sequence_9 = { 442b44247c 41c1e80a e8???????? f644246010 740a }
            // n = 5, score = 100
            //   442b44247c           | cmp                 dword ptr [eax], ebx
            //   41c1e80a             | cmovl               ebx, dword ptr [eax]
            //   e8????????           |                     
            //   f644246010           | mov                 edi, 1
            //   740a                 | cmp                 ecx, ebx

        $sequence_10 = { 4c8d0d2ba3ffff 41bb00020000 408a2f 413aea 0f8524f9ffff 4438942490000000 }
            // n = 6, score = 100
            //   4c8d0d2ba3ffff       | dec                 esp
            //   41bb00020000         | lea                 ecx, [0xffffa32b]
            //   408a2f               | inc                 ecx
            //   413aea               | mov                 ebx, 0x200
            //   0f8524f9ffff         | inc                 eax
            //   4438942490000000     | mov                 ch, byte ptr [edi]

        $sequence_11 = { bb00080000 3918 0f4c18 bf01000000 3bcb 0f8d8d000000 4c8d35f4c60000 }
            // n = 7, score = 100
            //   bb00080000           | dec                 eax
            //   3918                 | mov                 dword ptr [esp + 0x1a8], ebx
            //   0f4c18               | dec                 esp
            //   bf01000000           | lea                 ebx, [esp + 0x670]
            //   3bcb                 | dec                 ecx
            //   0f8d8d000000         | mov                 ebp, dword ptr [ebx + 0x20]
            //   4c8d35f4c60000       | dec                 ecx

        $sequence_12 = { 4883c440 5d c3 4055 4883ec20 488bea 488b01 }
            // n = 7, score = 100
            //   4883c440             | jge                 0x9d
            //   5d                   | dec                 esp
            //   c3                   | lea                 esi, [0xc6f4]
            //   4055                 | dec                 eax
            //   4883ec20             | lea                 ecx, [0xe354]
            //   488bea               | test                byte ptr [ecx + 8], 0x20
            //   488b01               | je                  0x1d

        $sequence_13 = { eb4e 488b0d???????? 488d542434 e8???????? eb3b }
            // n = 5, score = 100
            //   eb4e                 | xor                 edx, edx
            //   488b0d????????       |                     
            //   488d542434           | inc                 esp
            //   e8????????           |                     
            //   eb3b                 | sub                 eax, dword ptr [esp + 0x7c]

        $sequence_14 = { e8???????? 4c8d9c2470060000 498b6b20 498b7328 498be3 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   4c8d9c2470060000     | cmp                 byte ptr [esp + 0x90], dl
            //   498b6b20             | mov                 ebp, eax
            //   498b7328             | test                eax, eax
            //   498be3               | je                  0x124

        $sequence_15 = { 488d0d54e30000 f6410820 7417 33d2 }
            // n = 4, score = 100
            //   488d0d54e30000       | mov                 esi, dword ptr [ebx + 0x28]
            //   f6410820             | dec                 ecx
            //   7417                 | mov                 esp, ebx
            //   33d2                 | mov                 ebx, 0x800

    condition:
        7 of them and filesize < 212992
}