rule win_odinaff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.odinaff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.odinaff"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 c745983c000000 c745ac00010000 8955c4 c745c800080000 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   c745983c000000       | mov                 dword ptr [ebp - 0x68], 0x3c
            //   c745ac00010000       | mov                 dword ptr [ebp - 0x54], 0x100
            //   8955c4               | mov                 dword ptr [ebp - 0x3c], edx
            //   c745c800080000       | mov                 dword ptr [ebp - 0x38], 0x800

        $sequence_1 = { f7de 85c0 7408 50 }
            // n = 4, score = 200
            //   f7de                 | neg                 esi
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   50                   | push                eax

        $sequence_2 = { 83c410 f7d8 1bf6 8b45e8 f7de 85c0 }
            // n = 6, score = 200
            //   83c410               | add                 esp, 0x10
            //   f7d8                 | neg                 eax
            //   1bf6                 | sbb                 esi, esi
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   f7de                 | neg                 esi
            //   85c0                 | test                eax, eax

        $sequence_3 = { 6a00 51 52 50 ff15???????? 8945e8 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_4 = { c745fc00010000 ff15???????? 50 ff15???????? 8bf8 8d45fc 50 }
            // n = 7, score = 200
            //   c745fc00010000       | mov                 dword ptr [ebp - 4], 0x100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_5 = { b8???????? e8???????? 8b1d???????? 83c410 f7d8 1bf6 8b45e8 }
            // n = 7, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b1d????????         |                     
            //   83c410               | add                 esp, 0x10
            //   f7d8                 | neg                 eax
            //   1bf6                 | sbb                 esi, esi
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_6 = { 53 56 57 8b3d???????? 6800001000 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   6800001000           | push                0x100000

        $sequence_7 = { 68???????? 68???????? 53 8bf0 ff15???????? 83c40c }
            // n = 6, score = 200
            //   68????????           |                     
            //   68????????           |                     
            //   53                   | push                ebx
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_8 = { 6a00 6a00 51 ff15???????? 8b45fc 85c0 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   85c0                 | test                eax, eax

        $sequence_9 = { ffd3 8b3d???????? 50 ffd7 6808020000 }
            // n = 5, score = 200
            //   ffd3                 | call                ebx
            //   8b3d????????         |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   6808020000           | push                0x208

    condition:
        7 of them and filesize < 73728
}