rule win_oldbait_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.oldbait."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oldbait"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7409 43 83c104 83fb40 72f3 }
            // n = 5, score = 400
            //   7409                 | je                  0xb
            //   43                   | inc                 ebx
            //   83c104               | add                 ecx, 4
            //   83fb40               | cmp                 ebx, 0x40
            //   72f3                 | jb                  0xfffffff5

        $sequence_1 = { 8b86f5b11800 8945cc 8b86fdb11800 8945bc }
            // n = 4, score = 400
            //   8b86f5b11800         | mov                 eax, dword ptr [esi + 0x18b1f5]
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   8b86fdb11800         | mov                 eax, dword ptr [esi + 0x18b1fd]
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax

        $sequence_2 = { 05d4db1900 8945f4 ff35???????? ff75fc }
            // n = 4, score = 400
            //   05d4db1900           | add                 eax, 0x19dbd4
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   ff35????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_3 = { 8d4b08 51 50 ff75e4 }
            // n = 4, score = 400
            //   8d4b08               | lea                 ecx, [ebx + 8]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff75e4               | push                dword ptr [ebp - 0x1c]

        $sequence_4 = { 50 57 ff55e8 6800080000 ff750c }
            // n = 5, score = 400
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff55e8               | call                dword ptr [ebp - 0x18]
            //   6800080000           | push                0x800
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { 3571281424 42 3bd6 894510 72da 8bc7 5f }
            // n = 7, score = 400
            //   3571281424           | xor                 eax, 0x24142871
            //   42                   | inc                 edx
            //   3bd6                 | cmp                 edx, esi
            //   894510               | mov                 dword ptr [ebp + 0x10], eax
            //   72da                 | jb                  0xffffffdc
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi

        $sequence_6 = { 56 56 50 ff75ac }
            // n = 4, score = 400
            //   56                   | push                esi
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff75ac               | push                dword ptr [ebp - 0x54]

        $sequence_7 = { 6a00 6a01 6800000080 ff75f8 ff15???????? }
            // n = 5, score = 400
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6800000080           | push                0x80000000
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     

        $sequence_8 = { 57 8b7d08 8d70ff 85f6 }
            // n = 4, score = 400
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8d70ff               | lea                 esi, [eax - 1]
            //   85f6                 | test                esi, esi

        $sequence_9 = { 888800b01800 ebda 8b45fc 0531b11800 50 8b45f8 }
            // n = 6, score = 400
            //   888800b01800         | mov                 byte ptr [eax + 0x18b000], cl
            //   ebda                 | jmp                 0xffffffdc
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0531b11800           | add                 eax, 0x18b131
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_10 = { 47 0504040000 83ff08 72f0 83ff08 0f83a6000000 }
            // n = 6, score = 400
            //   47                   | inc                 edi
            //   0504040000           | add                 eax, 0x404
            //   83ff08               | cmp                 edi, 8
            //   72f0                 | jb                  0xfffffff2
            //   83ff08               | cmp                 edi, 8
            //   0f83a6000000         | jae                 0xac

        $sequence_11 = { 6a40 6800300000 68d4fd1900 6a00 ff15???????? }
            // n = 5, score = 400
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   68d4fd1900           | push                0x19fdd4
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_12 = { 50 ff7508 ff55e0 ff7508 8d83fcf7ffff }
            // n = 5, score = 400
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff55e0               | call                dword ptr [ebp - 0x20]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d83fcf7ffff         | lea                 eax, [ebx - 0x804]

        $sequence_13 = { 0f84d3010000 837d0800 0f84c9010000 837ddc0c 7518 }
            // n = 5, score = 400
            //   0f84d3010000         | je                  0x1d9
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   0f84c9010000         | je                  0x1cf
            //   837ddc0c             | cmp                 dword ptr [ebp - 0x24], 0xc
            //   7518                 | jne                 0x1a

        $sequence_14 = { 7626 8b4510 8bca 83f101 83e107 d3e8 }
            // n = 6, score = 400
            //   7626                 | jbe                 0x28
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8bca                 | mov                 ecx, edx
            //   83f101               | xor                 ecx, 1
            //   83e107               | and                 ecx, 7
            //   d3e8                 | shr                 eax, cl

        $sequence_15 = { 55 8bec 8b450c 56 33d2 57 8b7d08 }
            // n = 7, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   33d2                 | xor                 edx, edx
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_16 = { 8b45f8 301c07 41 47 3b4d10 }
            // n = 5, score = 100
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   301c07               | xor                 byte ptr [edi + eax], bl
            //   41                   | inc                 ecx
            //   47                   | inc                 edi
            //   3b4d10               | cmp                 ecx, dword ptr [ebp + 0x10]

        $sequence_17 = { 50 8d45c4 50 68???????? ff35???????? ffd6 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff35????????         |                     
            //   ffd6                 | call                esi

        $sequence_18 = { ff55d8 8bd8 83fbff 752c 8d45c4 50 }
            // n = 6, score = 100
            //   ff55d8               | call                dword ptr [ebp - 0x28]
            //   8bd8                 | mov                 ebx, eax
            //   83fbff               | cmp                 ebx, -1
            //   752c                 | jne                 0x2e
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   50                   | push                eax

        $sequence_19 = { 6a00 ff750c ff75fc ff55f0 }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff55f0               | call                dword ptr [ebp - 0x10]

        $sequence_20 = { 6a64 50 6a01 6a00 }
            // n = 4, score = 100
            //   6a64                 | push                0x64
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_21 = { ffd6 ffd0 53 ff55e4 90 90 90 }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   ffd0                 | call                eax
            //   53                   | push                ebx
            //   ff55e4               | call                dword ptr [ebp - 0x1c]
            //   90                   | nop                 
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_22 = { 50 ff75e0 e8???????? 90 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   e8????????           |                     
            //   90                   | nop                 

        $sequence_23 = { 57 8d45ec 57 50 53 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   57                   | push                edi
            //   50                   | push                eax
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 172032
}