rule win_olympic_destroyer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.olympic_destroyer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.olympic_destroyer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 33c0 89542414 57 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   33c0                 | xor                 eax, eax
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   57                   | push                edi

        $sequence_1 = { 85c0 7453 8b44242c 8d4c2410 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7453                 | je                  0x55
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   8d4c2410             | lea                 ecx, [esp + 0x10]

        $sequence_2 = { ffd7 85c0 0f848c000000 68???????? 8d85c0f9ffff 50 }
            // n = 6, score = 100
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   0f848c000000         | je                  0x92
            //   68????????           |                     
            //   8d85c0f9ffff         | lea                 eax, [ebp - 0x640]
            //   50                   | push                eax

        $sequence_3 = { 8985d4f7ffff 8d8580f7ffff 56 50 89b5d8f7ffff }
            // n = 5, score = 100
            //   8985d4f7ffff         | mov                 dword ptr [ebp - 0x82c], eax
            //   8d8580f7ffff         | lea                 eax, [ebp - 0x880]
            //   56                   | push                esi
            //   50                   | push                eax
            //   89b5d8f7ffff         | mov                 dword ptr [ebp - 0x828], esi

        $sequence_4 = { 51 8bce 8b4004 894510 e8???????? 8b4d10 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   894510               | mov                 dword ptr [ebp + 0x10], eax
            //   e8????????           |                     
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]

        $sequence_5 = { 51 8bcf 89442424 e8???????? 8b542424 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8bcf                 | mov                 ecx, edi
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   e8????????           |                     
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]

        $sequence_6 = { 51 8bcb 8975c4 e8???????? 83c404 8945e4 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   8bcb                 | mov                 ecx, ebx
            //   8975c4               | mov                 dword ptr [ebp - 0x3c], esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax

        $sequence_7 = { 83e801 743e 83e805 756d 50 50 8b4104 }
            // n = 7, score = 100
            //   83e801               | sub                 eax, 1
            //   743e                 | je                  0x40
            //   83e805               | sub                 eax, 5
            //   756d                 | jne                 0x6f
            //   50                   | push                eax
            //   50                   | push                eax
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]

        $sequence_8 = { 8945fc 53 56 8d45e8 33f6 50 8975e8 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   33f6                 | xor                 esi, esi
            //   50                   | push                eax
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi

        $sequence_9 = { ff15???????? 85c0 0f88ac000000 6a00 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f88ac000000         | js                  0xb2
            //   6a00                 | push                0

        $sequence_10 = { 51 8bce 8d52ff e8???????? 83c408 85c0 0f851f040000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   8d52ff               | lea                 edx, [edx - 1]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f851f040000         | jne                 0x425

        $sequence_11 = { 51 8bce 8944244c 89bc2480000000 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   8944244c             | mov                 dword ptr [esp + 0x4c], eax
            //   89bc2480000000       | mov                 dword ptr [esp + 0x80], edi

        $sequence_12 = { 3bc6 742a 0185f0efffff 8b85ecefffff }
            // n = 4, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   742a                 | je                  0x2c
            //   0185f0efffff         | add                 dword ptr [ebp - 0x1010], eax
            //   8b85ecefffff         | mov                 eax, dword ptr [ebp - 0x1014]

        $sequence_13 = { a4 4a 40 00d0 4a 40 }
            // n = 6, score = 100
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   4a                   | dec                 edx
            //   40                   | inc                 eax
            //   00d0                 | add                 al, dl
            //   4a                   | dec                 edx
            //   40                   | inc                 eax

        $sequence_14 = { ff74241c ff15???????? 5f 33c0 5e 40 5b }
            // n = 7, score = 100
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   40                   | inc                 eax
            //   5b                   | pop                 ebx

        $sequence_15 = { 0f8794020000 ff2485bc4b5500 51 8d542454 e8???????? 83c404 85c0 }
            // n = 7, score = 100
            //   0f8794020000         | ja                  0x29a
            //   ff2485bc4b5500       | jmp                 dword ptr [eax*4 + 0x554bbc]
            //   51                   | push                ecx
            //   8d542454             | lea                 edx, [esp + 0x54]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_16 = { 8b6c2424 55 6a40 ff15???????? 89442418 85c0 }
            // n = 6, score = 100
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   55                   | push                ebp
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   85c0                 | test                eax, eax

        $sequence_17 = { 51 8bcb e8???????? 8a45dc }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8a45dc               | mov                 al, byte ptr [ebp - 0x24]

        $sequence_18 = { 89442414 e8???????? 85c0 7415 8d4e08 }
            // n = 5, score = 100
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17
            //   8d4e08               | lea                 ecx, [esi + 8]

        $sequence_19 = { 89442430 8b442444 89442434 751f }
            // n = 4, score = 100
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   8b442444             | mov                 eax, dword ptr [esp + 0x44]
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   751f                 | jne                 0x21

        $sequence_20 = { 51 8bce e8???????? 6a00 68???????? }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_21 = { 50 ffd7 85c0 747a ffb590f9ffff e8???????? eb5f }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   747a                 | je                  0x7c
            //   ffb590f9ffff         | push                dword ptr [ebp - 0x670]
            //   e8????????           |                     
            //   eb5f                 | jmp                 0x61

        $sequence_22 = { 56 ff15???????? 6880ee3600 ff15???????? }
            // n = 4, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6880ee3600           | push                0x36ee80
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 1392640
}