rule win_ondritols_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ondritols."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ondritols"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 59 894df8 8b4df8 e8???????? 50 8b45f8 }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   59                   | pop                 ecx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_1 = { c745fcffffffff 8d4d10 e8???????? 8a8523ffffff eb1e eb9c c6852fffffff01 }
            // n = 7, score = 100
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8d4d10               | lea                 ecx, [ebp + 0x10]
            //   e8????????           |                     
            //   8a8523ffffff         | mov                 al, byte ptr [ebp - 0xdd]
            //   eb1e                 | jmp                 0x20
            //   eb9c                 | jmp                 0xffffff9e
            //   c6852fffffff01       | mov                 byte ptr [ebp - 0xd1], 1

        $sequence_2 = { c745fc00000000 8b4508 c1f805 8b4d08 83e11f c1e106 8b1485e0ca4600 }
            // n = 7, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c1f805               | sar                 eax, 5
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   8b1485e0ca4600       | mov                 edx, dword ptr [eax*4 + 0x46cae0]

        $sequence_3 = { 50 8d45f4 64a300000000 894dec 6a01 8d8518ffffff }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   6a01                 | push                1
            //   8d8518ffffff         | lea                 eax, [ebp - 0xe8]

        $sequence_4 = { 7409 8b55e4 c70201000000 eb15 c745e400000000 c745f000000000 c745e848a54600 }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   c70201000000         | mov                 dword ptr [edx], 1
            //   eb15                 | jmp                 0x17
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   c745e848a54600       | mov                 dword ptr [ebp - 0x18], 0x46a548

        $sequence_5 = { 895f14 895f18 39b530ffffff 720f 8b951cffffff 52 e8???????? }
            // n = 7, score = 100
            //   895f14               | mov                 dword ptr [edi + 0x14], ebx
            //   895f18               | mov                 dword ptr [edi + 0x18], ebx
            //   39b530ffffff         | cmp                 dword ptr [ebp - 0xd0], esi
            //   720f                 | jb                  0x11
            //   8b951cffffff         | mov                 edx, dword ptr [ebp - 0xe4]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_6 = { e8???????? 8b45e4 50 e8???????? 83c408 885dfc 8d7310 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   8d7310               | lea                 esi, [ebx + 0x10]

        $sequence_7 = { 746a 833d????????10 720e a1???????? 50 e8???????? 83c404 }
            // n = 7, score = 100
            //   746a                 | je                  0x6c
            //   833d????????10       |                     
            //   720e                 | jb                  0x10
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_8 = { c645fc04 e8???????? 83c404 3bc3 0f84a7020000 8906 }
            // n = 6, score = 100
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3bc3                 | cmp                 eax, ebx
            //   0f84a7020000         | je                  0x2ad
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_9 = { 8d8568f5ffff 50 e8???????? 83c404 83c00b 83f83c }
            // n = 6, score = 100
            //   8d8568f5ffff         | lea                 eax, [ebp - 0xa98]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83c00b               | add                 eax, 0xb
            //   83f83c               | cmp                 eax, 0x3c

    condition:
        7 of them and filesize < 964608
}