rule win_onhat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.onhat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.onhat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c684248c00000025 c684248d00000064 c684248e00000000 ffd6 83c40c }
            // n = 5, score = 200
            //   c684248c00000025     | mov                 byte ptr [esp + 0x8c], 0x25
            //   c684248d00000064     | mov                 byte ptr [esp + 0x8d], 0x64
            //   c684248e00000000     | mov                 byte ptr [esp + 0x8e], 0
            //   ffd6                 | call                esi
            //   83c40c               | add                 esp, 0xc

        $sequence_1 = { c644242956 885c242a c644242b50 c644242c4f c644242d52 }
            // n = 5, score = 200
            //   c644242956           | mov                 byte ptr [esp + 0x29], 0x56
            //   885c242a             | mov                 byte ptr [esp + 0x2a], bl
            //   c644242b50           | mov                 byte ptr [esp + 0x2b], 0x50
            //   c644242c4f           | mov                 byte ptr [esp + 0x2c], 0x4f
            //   c644242d52           | mov                 byte ptr [esp + 0x2d], 0x52

        $sequence_2 = { c644242761 c644242874 88442429 c644241c4e c644241d6f c644241e48 }
            // n = 6, score = 200
            //   c644242761           | mov                 byte ptr [esp + 0x27], 0x61
            //   c644242874           | mov                 byte ptr [esp + 0x28], 0x74
            //   88442429             | mov                 byte ptr [esp + 0x29], al
            //   c644241c4e           | mov                 byte ptr [esp + 0x1c], 0x4e
            //   c644241d6f           | mov                 byte ptr [esp + 0x1d], 0x6f
            //   c644241e48           | mov                 byte ptr [esp + 0x1e], 0x48

        $sequence_3 = { 33d2 8a542432 8acf 50 51 }
            // n = 5, score = 200
            //   33d2                 | xor                 edx, edx
            //   8a542432             | mov                 dl, byte ptr [esp + 0x32]
            //   8acf                 | mov                 cl, bh
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_4 = { 66ab aa 55 8d442458 6a64 50 51 }
            // n = 7, score = 200
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   55                   | push                ebp
            //   8d442458             | lea                 eax, [esp + 0x58]
            //   6a64                 | push                0x64
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_5 = { 89442424 0f8404020000 8b4c2414 50 }
            // n = 4, score = 200
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   0f8404020000         | je                  0x20a
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   50                   | push                eax

        $sequence_6 = { 33c0 5e 83c414 c3 8b4c240c 51 }
            // n = 6, score = 200
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   83c414               | add                 esp, 0x14
            //   c3                   | ret                 
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   51                   | push                ecx

        $sequence_7 = { 55 8d442458 6a64 50 51 e8???????? }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8d442458             | lea                 eax, [esp + 0x58]
            //   6a64                 | push                0x64
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_8 = { 6689542412 e8???????? 83f8ff 7507 33c0 5e 83c410 }
            // n = 7, score = 200
            //   6689542412           | mov                 word ptr [esp + 0x12], dx
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   83c410               | add                 esp, 0x10

        $sequence_9 = { 56 e8???????? b14f 83c408 884c2411 b020 884c241a }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   b14f                 | mov                 cl, 0x4f
            //   83c408               | add                 esp, 8
            //   884c2411             | mov                 byte ptr [esp + 0x11], cl
            //   b020                 | mov                 al, 0x20
            //   884c241a             | mov                 byte ptr [esp + 0x1a], cl

    condition:
        7 of them and filesize < 57344
}