rule win_onliner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.onliner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.onliner"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8bf0 85f6 0f85ab000000 8b45f8 8945f4 e9???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f85ab000000         | jne                 0xb1
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   e9????????           |                     

        $sequence_1 = { 58 e8???????? 0f8436010000 a1???????? e8???????? 3c01 7412 }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   0f8436010000         | je                  0x13c
            //   a1????????           |                     
            //   e8????????           |                     
            //   3c01                 | cmp                 al, 1
            //   7412                 | je                  0x14

        $sequence_2 = { 058a4c2a8d ba14000000 e8???????? 03c7 8bf0 8bc7 33c6 }
            // n = 7, score = 100
            //   058a4c2a8d           | add                 eax, 0x8d2a4c8a
            //   ba14000000           | mov                 edx, 0x14
            //   e8????????           |                     
            //   03c7                 | add                 eax, edi
            //   8bf0                 | mov                 esi, eax
            //   8bc7                 | mov                 eax, edi
            //   33c6                 | xor                 eax, esi

        $sequence_3 = { 8910 33c0 8ac3 8d448604 8b17 e8???????? 8b17 }
            // n = 7, score = 100
            //   8910                 | mov                 dword ptr [eax], edx
            //   33c0                 | xor                 eax, eax
            //   8ac3                 | mov                 al, bl
            //   8d448604             | lea                 eax, [esi + eax*4 + 4]
            //   8b17                 | mov                 edx, dword ptr [edi]
            //   e8????????           |                     
            //   8b17                 | mov                 edx, dword ptr [edi]

        $sequence_4 = { e8???????? ff75ec 8b45fc e8???????? 0fb7c0 8d55e4 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   0fb7c0               | movzx               eax, ax
            //   8d55e4               | lea                 edx, [ebp - 0x1c]
            //   e8????????           |                     

        $sequence_5 = { eb41 83c0bf 83e81a 7225 83c0fa 83e81a }
            // n = 6, score = 100
            //   eb41                 | jmp                 0x43
            //   83c0bf               | add                 eax, -0x41
            //   83e81a               | sub                 eax, 0x1a
            //   7225                 | jb                  0x27
            //   83c0fa               | add                 eax, -6
            //   83e81a               | sub                 eax, 0x1a

        $sequence_6 = { 837df800 750f 8bc3 8b55fc e8???????? e9???????? 8b45f8 }
            // n = 7, score = 100
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   750f                 | jne                 0x11
            //   8bc3                 | mov                 eax, ebx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   e9????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_7 = { 8bd7 e8???????? 8b0424 833800 742e 8b0424 }
            // n = 6, score = 100
            //   8bd7                 | mov                 edx, edi
            //   e8????????           |                     
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   833800               | cmp                 dword ptr [eax], 0
            //   742e                 | je                  0x30
            //   8b0424               | mov                 eax, dword ptr [esp]

        $sequence_8 = { 8993b4010000 8d8398000000 e8???????? 8d9398000000 8b83b4010000 e8???????? 8bc3 }
            // n = 7, score = 100
            //   8993b4010000         | mov                 dword ptr [ebx + 0x1b4], edx
            //   8d8398000000         | lea                 eax, [ebx + 0x98]
            //   e8????????           |                     
            //   8d9398000000         | lea                 edx, [ebx + 0x98]
            //   8b83b4010000         | mov                 eax, dword ptr [ebx + 0x1b4]
            //   e8????????           |                     
            //   8bc3                 | mov                 eax, ebx

        $sequence_9 = { 8bcf 83e11f c1e106 8b048560f94c00 c644080401 57 e8???????? }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   8b048560f94c00       | mov                 eax, dword ptr [eax*4 + 0x4cf960]
            //   c644080401           | mov                 byte ptr [eax + ecx + 4], 1
            //   57                   | push                edi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1736704
}