rule win_orchard_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.orchard."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.orchard"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b49fc 83c223 2bc1 83c0fc 83f81f 0f877e030000 52 }
            // n = 7, score = 200
            //   8b49fc               | mov                 ecx, dword ptr [ecx - 4]
            //   83c223               | add                 edx, 0x23
            //   2bc1                 | sub                 eax, ecx
            //   83c0fc               | add                 eax, -4
            //   83f81f               | cmp                 eax, 0x1f
            //   0f877e030000         | ja                  0x384
            //   52                   | push                edx

        $sequence_1 = { 83c028 895de0 8b5de8 894348 }
            // n = 4, score = 200
            //   83c028               | add                 eax, 0x28
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   8b5de8               | mov                 ebx, dword ptr [ebp - 0x18]
            //   894348               | mov                 dword ptr [ebx + 0x48], eax

        $sequence_2 = { 8b75a8 46 56 e8???????? 8bf8 }
            // n = 5, score = 200
            //   8b75a8               | mov                 esi, dword ptr [ebp - 0x58]
            //   46                   | inc                 esi
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_3 = { 89542420 f7e1 8bc8 8954240c }
            // n = 4, score = 200
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   f7e1                 | mul                 ecx
            //   8bc8                 | mov                 ecx, eax
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx

        $sequence_4 = { 56 ff15???????? ff15???????? 50 6a00 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_5 = { 8d442410 50 ff15???????? 6685c0 }
            // n = 4, score = 200
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6685c0               | test                ax, ax

        $sequence_6 = { 6a05 c70600000000 c7461000000000 c746140f000000 68???????? }
            // n = 5, score = 200
            //   6a05                 | push                5
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   68????????           |                     

        $sequence_7 = { f7f9 81c2d0070000 52 ffd6 }
            // n = 4, score = 200
            //   f7f9                 | idiv                ecx
            //   81c2d0070000         | add                 edx, 0x7d0
            //   52                   | push                edx
            //   ffd6                 | call                esi

        $sequence_8 = { 0f877e030000 52 51 e8???????? 83c408 }
            // n = 5, score = 200
            //   0f877e030000         | ja                  0x384
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_9 = { 50 ff15???????? 83f805 7507 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83f805               | cmp                 eax, 5
            //   7507                 | jne                 9

        $sequence_10 = { c645fc08 e8???????? 894604 83c404 8d4718 897034 8d5804 }
            // n = 7, score = 200
            //   c645fc08             | mov                 byte ptr [ebp - 4], 8
            //   e8????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   83c404               | add                 esp, 4
            //   8d4718               | lea                 eax, [edi + 0x18]
            //   897034               | mov                 dword ptr [eax + 0x34], esi
            //   8d5804               | lea                 ebx, [eax + 4]

        $sequence_11 = { 83c404 e8???????? 99 b95b000000 f7f9 }
            // n = 5, score = 200
            //   83c404               | add                 esp, 4
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b95b000000           | mov                 ecx, 0x5b
            //   f7f9                 | idiv                ecx

        $sequence_12 = { 89542428 8b54240c 83d200 03c1 }
            // n = 4, score = 200
            //   89542428             | mov                 dword ptr [esp + 0x28], edx
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   83d200               | adc                 edx, 0
            //   03c1                 | add                 eax, ecx

        $sequence_13 = { e8???????? 894604 83c318 897730 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   83c318               | add                 ebx, 0x18
            //   897730               | mov                 dword ptr [edi + 0x30], esi

        $sequence_14 = { 8bc8 8bc7 8d9d48ffffff c645fc03 }
            // n = 4, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   8bc7                 | mov                 eax, edi
            //   8d9d48ffffff         | lea                 ebx, [ebp - 0xb8]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3

        $sequence_15 = { 8bc8 8bc7 8d5c2460 c68424a800000001 e8???????? 50 }
            // n = 6, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   8bc7                 | mov                 eax, edi
            //   8d5c2460             | lea                 ebx, [esp + 0x60]
            //   c68424a800000001     | mov                 byte ptr [esp + 0xa8], 1
            //   e8????????           |                     
            //   50                   | push                eax

    condition:
        7 of them and filesize < 4716352
}