rule win_oski_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.oski."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.oski"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 a1???????? 50 8d8df0feffff 51 e8???????? }
            // n = 6, score = 1100
            //   50                   | push                eax
            //   a1????????           |                     
            //   50                   | push                eax
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_1 = { 25ff7f0000 c3 8bff 55 8bec 83ec14 ff7510 }
            // n = 7, score = 1000
            //   25ff7f0000           | and                 eax, 0x7fff
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_2 = { 83c40c e8???????? 50 a1???????? 50 }
            // n = 5, score = 900
            //   83c40c               | add                 esp, 0xc
            //   e8????????           |                     
            //   50                   | push                eax
            //   a1????????           |                     
            //   50                   | push                eax

        $sequence_3 = { 8975f0 e8???????? cc 8bff 55 8bec 8b550c }
            // n = 7, score = 900
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   e8????????           |                     
            //   cc                   | int3                
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_4 = { 393d???????? 0f94c0 33d2 0bc8 }
            // n = 4, score = 800
            //   393d????????         |                     
            //   0f94c0               | sete                al
            //   33d2                 | xor                 edx, edx
            //   0bc8                 | or                  ecx, eax

        $sequence_5 = { 57 e8???????? 8b4618 83c40c 6a00 6a00 }
            // n = 6, score = 800
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b4618               | mov                 eax, dword ptr [esi + 0x18]
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { 56 8d85ecfeffff 50 8d8dd0fcffff 51 eb18 f685a4fcffff10 }
            // n = 7, score = 800
            //   56                   | push                esi
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   50                   | push                eax
            //   8d8dd0fcffff         | lea                 ecx, [ebp - 0x330]
            //   51                   | push                ecx
            //   eb18                 | jmp                 0x1a
            //   f685a4fcffff10       | test                byte ptr [ebp - 0x35c], 0x10

        $sequence_7 = { 8b4508 8945b0 8b450c 33db 8bc8 }
            // n = 5, score = 800
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   33db                 | xor                 ebx, ebx
            //   8bc8                 | mov                 ecx, eax

        $sequence_8 = { f3c3 e9???????? 8bff 55 8bec 83ec1c a1???????? }
            // n = 7, score = 800
            //   f3c3                 | ret                 
            //   e9????????           |                     
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec1c               | sub                 esp, 0x1c
            //   a1????????           |                     

        $sequence_9 = { ebe9 6a02 e8???????? 59 c3 e8???????? }
            // n = 6, score = 700
            //   ebe9                 | jmp                 0xffffffeb
            //   6a02                 | push                2
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   e8????????           |                     

        $sequence_10 = { 8b5508 52 a1???????? 50 8d8de8fdffff }
            // n = 5, score = 400
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   a1????????           |                     
            //   50                   | push                eax
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]

        $sequence_11 = { 51 e8???????? 83c40c 8985e4fdffff 83bde4fdffff00 }
            // n = 5, score = 400
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8985e4fdffff         | mov                 dword ptr [ebp - 0x21c], eax
            //   83bde4fdffff00       | cmp                 dword ptr [ebp - 0x21c], 0

        $sequence_12 = { e8???????? 83c404 8b0d???????? 51 ff15???????? a3???????? }
            // n = 6, score = 400
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_13 = { 8b511c 83c220 52 6a00 }
            // n = 4, score = 400
            //   8b511c               | mov                 edx, dword ptr [ecx + 0x1c]
            //   83c220               | add                 edx, 0x20
            //   52                   | push                edx
            //   6a00                 | push                0

        $sequence_14 = { 52 6a00 68???????? ff15???????? 8945f0 837df000 }
            // n = 6, score = 400
            //   52                   | push                edx
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0

        $sequence_15 = { 83c404 8b55f8 8955f4 8b45f4 50 e8???????? 83c404 }
            // n = 7, score = 400
            //   83c404               | add                 esp, 4
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_16 = { 51 6800020000 8b55f4 52 ff15???????? 8945f0 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   6800020000           | push                0x200
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

    condition:
        7 of them and filesize < 423936
}