rule win_outlook_backdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.outlook_backdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.outlook_backdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8412fdffff ff442410 ff4c2418 837c241800 7fdb e9???????? 56 }
            // n = 7, score = 600
            //   0f8412fdffff         | je                  0xfffffd18
            //   ff442410             | inc                 dword ptr [esp + 0x10]
            //   ff4c2418             | dec                 dword ptr [esp + 0x18]
            //   837c241800           | cmp                 dword ptr [esp + 0x18], 0
            //   7fdb                 | jg                  0xffffffdd
            //   e9????????           |                     
            //   56                   | push                esi

        $sequence_1 = { eb0a 8b7508 e8???????? 8bc6 8b4df4 5f 5e }
            // n = 7, score = 600
            //   eb0a                 | jmp                 0xc
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 7708 c6063f 46 c6063d 46 8bc6 2b45e0 }
            // n = 7, score = 600
            //   7708                 | ja                  0xa
            //   c6063f               | mov                 byte ptr [esi], 0x3f
            //   46                   | inc                 esi
            //   c6063d               | mov                 byte ptr [esi], 0x3d
            //   46                   | inc                 esi
            //   8bc6                 | mov                 eax, esi
            //   2b45e0               | sub                 eax, dword ptr [ebp - 0x20]

        $sequence_3 = { c645fc00 e8???????? 8b4df4 8b4508 64890d00000000 5e c9 }
            // n = 7, score = 600
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_4 = { e9???????? 33db 895c2414 8d442414 50 6a01 }
            // n = 6, score = 600
            //   e9????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_5 = { 8bf0 8d442418 8bcb e8???????? 8b08 8b4004 }
            // n = 6, score = 600
            //   8bf0                 | mov                 esi, eax
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_6 = { e8???????? 53 56 8d4dd8 eb29 }
            // n = 5, score = 600
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   eb29                 | jmp                 0x2b

        $sequence_7 = { 8365fc00 6bc01c 03818c000000 56 8b7508 50 }
            // n = 6, score = 600
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   6bc01c               | imul                eax, eax, 0x1c
            //   03818c000000         | add                 eax, dword ptr [ecx + 0x8c]
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_8 = { 8b4d08 83c410 8d5104 8bc1 3bca 7412 }
            // n = 6, score = 600
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c410               | add                 esp, 0x10
            //   8d5104               | lea                 edx, [ecx + 4]
            //   8bc1                 | mov                 eax, ecx
            //   3bca                 | cmp                 ecx, edx
            //   7412                 | je                  0x14

        $sequence_9 = { 50 e8???????? 8bf0 59 8d8528ffffff 50 e8???????? }
            // n = 7, score = 600
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   8d8528ffffff         | lea                 eax, [ebp - 0xd8]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2912256
}