rule win_overlay_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.overlay_rat"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 0f84c5000000 48 0f84f2000000 e9???????? 8b83d4030000 ba???????? }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   0f84c5000000         | je                  0xcb
            //   48                   | dec                 eax
            //   0f84f2000000         | je                  0xf8
            //   e9????????           |                     
            //   8b83d4030000         | mov                 eax, dword ptr [ebx + 0x3d4]
            //   ba????????           |                     

        $sequence_1 = { 8b10 ff5224 03c6 3b45ec 7f3a 8b55fc }
            // n = 6, score = 100
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff5224               | call                dword ptr [edx + 0x24]
            //   03c6                 | add                 eax, esi
            //   3b45ec               | cmp                 eax, dword ptr [ebp - 0x14]
            //   7f3a                 | jg                  0x3c
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_2 = { 8b83e0030000 ba10000000 e8???????? 8b83e0030000 33d2 e8???????? 8b83e0030000 }
            // n = 7, score = 100
            //   8b83e0030000         | mov                 eax, dword ptr [ebx + 0x3e0]
            //   ba10000000           | mov                 edx, 0x10
            //   e8????????           |                     
            //   8b83e0030000         | mov                 eax, dword ptr [ebx + 0x3e0]
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   8b83e0030000         | mov                 eax, dword ptr [ebx + 0x3e0]

        $sequence_3 = { 89842494000000 8b442460 89842498000000 8d542474 8b83a0020000 b904000000 8b38 }
            // n = 7, score = 100
            //   89842494000000       | mov                 dword ptr [esp + 0x94], eax
            //   8b442460             | mov                 eax, dword ptr [esp + 0x60]
            //   89842498000000       | mov                 dword ptr [esp + 0x98], eax
            //   8d542474             | lea                 edx, [esp + 0x74]
            //   8b83a0020000         | mov                 eax, dword ptr [ebx + 0x2a0]
            //   b904000000           | mov                 ecx, 4
            //   8b38                 | mov                 edi, dword ptr [eax]

        $sequence_4 = { 80f201 83e27f 0b049564ca6e10 8b55fc 894208 8b45fc c7400c03000000 }
            // n = 7, score = 100
            //   80f201               | xor                 dl, 1
            //   83e27f               | and                 edx, 0x7f
            //   0b049564ca6e10       | or                  eax, dword ptr [edx*4 + 0x106eca64]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   894208               | mov                 dword ptr [edx + 8], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c7400c03000000       | mov                 dword ptr [eax + 0xc], 3

        $sequence_5 = { 66baebff e8???????? 8b83f8030000 66c7808a000000ebff 899824010000 c7802001000030056c10 8b83fc030000 }
            // n = 7, score = 100
            //   66baebff             | mov                 dx, 0xffeb
            //   e8????????           |                     
            //   8b83f8030000         | mov                 eax, dword ptr [ebx + 0x3f8]
            //   66c7808a000000ebff     | mov    word ptr [eax + 0x8a], 0xffeb
            //   899824010000         | mov                 dword ptr [eax + 0x124], ebx
            //   c7802001000030056c10     | mov    dword ptr [eax + 0x120], 0x106c0530
            //   8b83fc030000         | mov                 eax, dword ptr [ebx + 0x3fc]

        $sequence_6 = { 6a00 0fb68bd9020000 8b93dc020000 8b83e4020000 e8???????? 8983dc020000 6a01 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   0fb68bd9020000       | movzx               ecx, byte ptr [ebx + 0x2d9]
            //   8b93dc020000         | mov                 edx, dword ptr [ebx + 0x2dc]
            //   8b83e4020000         | mov                 eax, dword ptr [ebx + 0x2e4]
            //   e8????????           |                     
            //   8983dc020000         | mov                 dword ptr [ebx + 0x2dc], eax
            //   6a01                 | push                1

        $sequence_7 = { 8d55ec 8b8634040000 e8???????? ff75ec 8d45f0 ba04000000 e8???????? }
            // n = 7, score = 100
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   8b8634040000         | mov                 eax, dword ptr [esi + 0x434]
            //   e8????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   ba04000000           | mov                 edx, 4
            //   e8????????           |                     

        $sequence_8 = { f5 1bc0 50 8b06 0fb64034 8b048558d16e10 }
            // n = 6, score = 100
            //   f5                   | cmc                 
            //   1bc0                 | sbb                 eax, eax
            //   50                   | push                eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   0fb64034             | movzx               eax, byte ptr [eax + 0x34]
            //   8b048558d16e10       | mov                 eax, dword ptr [eax*4 + 0x106ed158]

        $sequence_9 = { f7d7 0b7c2414 337c2410 03c7 03442454 05f33e706d 8bf8 }
            // n = 7, score = 100
            //   f7d7                 | not                 edi
            //   0b7c2414             | or                  edi, dword ptr [esp + 0x14]
            //   337c2410             | xor                 edi, dword ptr [esp + 0x10]
            //   03c7                 | add                 eax, edi
            //   03442454             | add                 eax, dword ptr [esp + 0x54]
            //   05f33e706d           | add                 eax, 0x6d703ef3
            //   8bf8                 | mov                 edi, eax

    condition:
        7 of them and filesize < 10592256
}