rule win_owlproxy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.owlproxy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.owlproxy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b4908 410fb7f0 488bfa 4c8d442450 488d542458 c744245014000000 ff15???????? }
            // n = 7, score = 200
            //   488b4908             | dec                 eax
            //   410fb7f0             | cmp                 ebx, esi
            //   488bfa               | je                  0xac0
            //   4c8d442450           | sub                 esi, ebx
            //   488d542458           | inc                 esp
            //   c744245014000000     | mov                 eax, esi
            //   ff15????????         |                     

        $sequence_1 = { 486bc000 488d0d42330200 8b542430 48891401 488d0d0b810100 e8???????? }
            // n = 6, score = 200
            //   486bc000             | inc                 ecx
            //   488d0d42330200       | mov                 eax, esp
            //   8b542430             | dec                 ecx
            //   48891401             | cmp                 edi, 1
            //   488d0d0b810100       | jae                 0x1e98
            //   e8????????           |                     

        $sequence_2 = { 55 57 4156 488da808feffff 4881ece0020000 48c7442478feffffff 48895818 }
            // n = 7, score = 200
            //   55                   | movups              xmm0, xmmword ptr [eax]
            //   57                   | inc                 ecx
            //   4156                 | movups              xmm1, xmmword ptr [eax + 0x10]
            //   488da808feffff       | dec                 esp
            //   4881ece0020000       | lea                 eax, [esp + 0x30]
            //   48c7442478feffffff     | dec    eax
            //   48895818             | mov                 ebx, ecx

        $sequence_3 = { e8???????? 4c8b742440 4c3b742448 7435 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   4c8b742440           | lea                 ecx, [0xffff118a]
            //   4c3b742448           | and                 edx, 0x1f
            //   7435                 | dec                 eax

        $sequence_4 = { 2bf3 448bc6 488bd3 488d8c2430010000 e8???????? 448b8424f8000000 }
            // n = 6, score = 200
            //   2bf3                 | and                 ebx, 0xfffffffb
            //   448bc6               | dec                 esp
            //   488bd3               | mov                 dword ptr [ebp - 0x40], edi
            //   488d8c2430010000     | dec                 eax
            //   e8????????           |                     
            //   448b8424f8000000     | mov                 dword ptr [ebp - 0x38], eax

        $sequence_5 = { 498936 49895e08 49897e10 4883bd8800000010 7209 488b4d70 e8???????? }
            // n = 7, score = 200
            //   498936               | dec                 eax
            //   49895e08             | mov                 eax, dword ptr [ecx + eax*8]
            //   49897e10             | inc                 ecx
            //   4883bd8800000010     | test                byte ptr [esp + eax + 8], 0x40
            //   7209                 | dec                 eax
            //   488b4d70             | lea                 ecx, [0x23eaa]
            //   e8????????           |                     

        $sequence_6 = { 415e 415d 415c 5f c3 488d0d2c290200 e8???????? }
            // n = 7, score = 200
            //   415e                 | dec                 eax
            //   415d                 | mov                 dword ptr [esp + 0x58], eax
            //   415c                 | dec                 eax
            //   5f                   | mov                 edi, edx
            //   c3                   | dec                 eax
            //   488d0d2c290200       | mov                 ebx, ecx
            //   e8????????           |                     

        $sequence_7 = { 480f4355b8 4533c0 488b4da8 ff15???????? 895db0 4c8d25f53c0200 }
            // n = 6, score = 200
            //   480f4355b8           | pop                 esi
            //   4533c0               | pop                 ebx
            //   488b4da8             | ret                 
            //   ff15????????         |                     
            //   895db0               | dec                 eax
            //   4c8d25f53c0200       | lea                 ecx, [0x223f1]

        $sequence_8 = { 4883ec20 488d0d53580100 ff15???????? 488d1566580100 488bc8 488bd8 ff15???????? }
            // n = 7, score = 200
            //   4883ec20             | test                eax, eax
            //   488d0d53580100       | dec                 esp
            //   ff15????????         |                     
            //   488d1566580100       | lea                 esi, [0x16176]
            //   488bc8               | dec                 eax
            //   488bd8               | mov                 edi, ebx
            //   ff15????????         |                     

        $sequence_9 = { 4885db 0f8480000000 410fb60437 8803 eb77 483bdf 756a }
            // n = 7, score = 200
            //   4885db               | dec                 ebp
            //   0f8480000000         | mov                 esi, dword ptr [esi]
            //   410fb60437           | dec                 eax
            //   8803                 | test                ebp, ebp
            //   eb77                 | dec                 edi
            //   483bdf               | lea                 edx, [ecx + ebx]
            //   756a                 | dec                 eax

    condition:
        7 of them and filesize < 475136
}