rule win_pandabanker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pandabanker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pandabanker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { d0c2 8ac2 d0c0 32c1 32c2 }
            // n = 5, score = 8600
            //   d0c2                 | rol                 dl, 1
            //   8ac2                 | mov                 al, dl
            //   d0c0                 | rol                 al, 1
            //   32c1                 | xor                 al, cl
            //   32c2                 | xor                 al, dl

        $sequence_1 = { 42 83fa10 72ee 8b5500 }
            // n = 4, score = 8600
            //   42                   | inc                 edx
            //   83fa10               | cmp                 edx, 0x10
            //   72ee                 | jb                  0xfffffff0
            //   8b5500               | mov                 edx, dword ptr [ebp]

        $sequence_2 = { 8bf2 57 8bf9 8d8df4fdffff }
            // n = 4, score = 8600
            //   8bf2                 | mov                 esi, edx
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8d8df4fdffff         | lea                 ecx, [ebp - 0x20c]

        $sequence_3 = { f3aa 8932 8d46f0 8b5500 }
            // n = 4, score = 8600
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   8932                 | mov                 dword ptr [edx], esi
            //   8d46f0               | lea                 eax, [esi - 0x10]
            //   8b5500               | mov                 edx, dword ptr [ebp]

        $sequence_4 = { 895c2414 8bf1 e8???????? 84c0 746d 83caff 8bce }
            // n = 7, score = 8600
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   746d                 | je                  0x6f
            //   83caff               | or                  edx, 0xffffffff
            //   8bce                 | mov                 ecx, esi

        $sequence_5 = { 8bf0 85f6 7414 e8???????? 8906 85c0 7509 }
            // n = 7, score = 8600
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7414                 | je                  0x16
            //   e8????????           |                     
            //   8906                 | mov                 dword ptr [esi], eax
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb

        $sequence_6 = { 33c0 33d2 89442418 3bfd 7359 }
            // n = 5, score = 8600
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   3bfd                 | cmp                 edi, ebp
            //   7359                 | jae                 0x5b

        $sequence_7 = { 8bce 2b0f 33448f4c 8944b74c 6a05 59 }
            // n = 6, score = 8600
            //   8bce                 | mov                 ecx, esi
            //   2b0f                 | sub                 ecx, dword ptr [edi]
            //   33448f4c             | xor                 eax, dword ptr [edi + ecx*4 + 0x4c]
            //   8944b74c             | mov                 dword ptr [edi + esi*4 + 0x4c], eax
            //   6a05                 | push                5
            //   59                   | pop                 ecx

        $sequence_8 = { 03c8 894c2434 8d5101 8bce e8???????? 85c0 }
            // n = 6, score = 8600
            //   03c8                 | add                 ecx, eax
            //   894c2434             | mov                 dword ptr [esp + 0x34], ecx
            //   8d5101               | lea                 edx, [ecx + 1]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { 75f9 2bce 5e 8d040a c3 33c0 c3 }
            // n = 7, score = 8600
            //   75f9                 | jne                 0xfffffffb
            //   2bce                 | sub                 ecx, esi
            //   5e                   | pop                 esi
            //   8d040a               | lea                 eax, [edx + ecx]
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 417792
}