rule win_pandora_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pandora."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pandora"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41ffc7 83f81e 0f8f88030000 4885ff 7418 488d47ff 498d04c6 }
            // n = 7, score = 100
            //   41ffc7               | dec                 esp
            //   83f81e               | sub                 eax, edi
            //   0f8f88030000         | dec                 eax
            //   4885ff               | lea                 eax, [ebx + 0xf]
            //   7418                 | dec                 eax
            //   488d47ff             | cmp                 eax, edi
            //   498d04c6             | jae                 0x98

        $sequence_1 = { 7424 838da400000010 448d4710 4c8b0d???????? 488d4c2430 33d2 41ffd1 }
            // n = 7, score = 100
            //   7424                 | rol                 edx, 0xa
            //   838da400000010       | inc                 ecx
            //   448d4710             | mov                 eax, esi
            //   4c8b0d????????       |                     
            //   488d4c2430           | add                 eax, 0xffffbb80
            //   33d2                 | dec                 esp
            //   41ffd1               | mov                 esp, dword ptr [esp + 0x58]

        $sequence_2 = { 48897c2418 4156 4883ec20 33ff 4533f6 4863df 488d0d88040300 }
            // n = 7, score = 100
            //   48897c2418           | cmp                 dword ptr [ebx], edi
            //   4156                 | jne                 0xca8
            //   4883ec20             | dec                 ebp
            //   33ff                 | mov                 ecx, ebp
            //   4533f6               | dec                 eax
            //   4863df               | lea                 ecx, [ebp - 0x50]
            //   488d0d88040300       | dec                 ebp

        $sequence_3 = { 415e c3 48895c2408 4889742410 57 4883ec20 4c8b5108 }
            // n = 7, score = 100
            //   415e                 | test                esi, esi
            //   c3                   | je                  0xfa6
            //   48895c2408           | inc                 ecx
            //   4889742410           | movzx               edi, ah
            //   57                   | dec                 eax
            //   4883ec20             | lea                 ecx, [ebx + esi]
            //   4c8b5108             | dec                 eax

        $sequence_4 = { 4c8d45b0 488d55c8 e8???????? 8bd8 85c0 7524 f7de }
            // n = 7, score = 100
            //   4c8d45b0             | test                edi, edi
            //   488d55c8             | mov                 ebp, eax
            //   e8????????           |                     
            //   8bd8                 | test                eax, eax
            //   85c0                 | jne                 0xfc6
            //   7524                 | dec                 eax
            //   f7de                 | lea                 eax, [edi + esi]

        $sequence_5 = { 8bcf 44335014 c1e918 0fb6d1 8bce }
            // n = 5, score = 100
            //   8bcf                 | inc                 ecx
            //   44335014             | mov                 edi, esp
            //   c1e918               | dec                 esp
            //   0fb6d1               | mov                 dword ptr [eax - 0x38], esi
            //   8bce                 | inc                 ebp

        $sequence_6 = { 498b06 4885c0 0f8432020000 8b4008 ffc8 83f806 0f8724020000 }
            // n = 7, score = 100
            //   498b06               | mov                 ecx, esp
            //   4885c0               | inc                 ecx
            //   0f8432020000         | xor                 ecx, edx
            //   8b4008               | inc                 ecx
            //   ffc8                 | and                 ecx, ebx
            //   83f806               | inc                 ecx
            //   0f8724020000         | xor                 ecx, esp

        $sequence_7 = { 488b05???????? 33d2 498bcc ffd0 4c8b642460 4c8b742448 488b7c2440 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   33d2                 | mov                 edx, edi
            //   498bcc               | dec                 eax
            //   ffd0                 | lea                 ecx, [esp + 0x30]
            //   4c8b642460           | mov                 ebx, eax
            //   4c8b742448           | test                eax, eax
            //   488b7c2440           | jne                 0x1933

        $sequence_8 = { 0bc8 0fb64238 c1e108 0bc8 0fb6423e 440bd0 894c2440 }
            // n = 7, score = 100
            //   0bc8                 | inc                 ecx
            //   0fb64238             | shr                 ecx, 8
            //   c1e108               | inc                 ebp
            //   0bc8                 | movzx               eax, dl
            //   0fb6423e             | inc                 ecx
            //   440bd0               | sub                 eax, eax
            //   894c2440             | shr                 eax, 8

        $sequence_9 = { 4503d3 418bc6 23c6 41c1c60a 0bf8 4181c34efd53a9 81c7e9766d7a }
            // n = 7, score = 100
            //   4503d3               | sub                 ebx, eax
            //   418bc6               | dec                 eax
            //   23c6                 | mov                 ecx, eax
            //   41c1c60a             | xor                 eax, eax
            //   0bf8                 | dec                 esp
            //   4181c34efd53a9       | cmp                 ebx, dword ptr [edi + ebx - 8]
            //   81c7e9766d7a         | setb                al

    condition:
        7 of them and filesize < 1032192
}