rule win_payloadbin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.payloadbin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.payloadbin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744243003000000 488d4c2470 66448bc9 4487c2 6699 4c8d48b0 }
            // n = 6, score = 100
            //   c744243003000000     | sub                 al, 0x30
            //   488d4c2470           | xchg                eax, ecx
            //   66448bc9             | insd                dword ptr es:[edi], dx
            //   4487c2               | jp                  0x28b
            //   6699                 | mov                 ecx, 0x7ffd
            //   4c8d48b0             | mov                 esi, eax

        $sequence_1 = { 4d0fbddc 23c6 480fb7cb 0bd8 0fbfca 6698 418919 }
            // n = 7, score = 100
            //   4d0fbddc             | inc                 esp
            //   23c6                 | movzx               eax, cx
            //   480fb7cb             | cmp                 ax, 0x19
            //   0bd8                 | dec                 esp
            //   0fbfca               | mov                 ecx, ebx
            //   6698                 | sub                 edx, edx
            //   418919               | stc                 

        $sequence_2 = { 68eb3a8171 55 68396f8656 6819276b5f 682109a155 4c8b6c2438 48c7442438404fa1db }
            // n = 7, score = 100
            //   68eb3a8171           | push                0x471a4227
            //   55                   | dec                 eax
            //   68396f8656           | add                 dword ptr [esp + 0x10], 0x45e72855
            //   6819276b5f           | test                byte ptr [esp], 0x3d
            //   682109a155           | inc                 ecx
            //   4c8b6c2438           | pop                 eax
            //   48c7442438404fa1db     | dec    eax

        $sequence_3 = { 4881c308000000 660fa4d81f f6d8 f9 9d d2e0 }
            // n = 6, score = 100
            //   4881c308000000       | mov                 bh, cl
            //   660fa4d81f           | inc                 eax
            //   f6d8                 | ror                 bh, cl
            //   f9                   | dec                 eax
            //   9d                   | sub                 eax, ecx
            //   d2e0                 | dec                 eax

        $sequence_4 = { 4153 310c24 6641ffc3 415b 403aea 6685d7 4863c9 }
            // n = 7, score = 100
            //   4153                 | dec                 eax
            //   310c24               | mov                 dword ptr [eax + 0x10], ebp
            //   6641ffc3             | dec                 eax
            //   415b                 | arpl                si, bx
            //   403aea               | dec                 eax
            //   6685d7               | mov                 dword ptr [eax + 0x18], esi
            //   4863c9               | xadd                bx, bx

        $sequence_5 = { f9 f8 4151 41d2e1 311c24 4532cd 4522ce }
            // n = 7, score = 100
            //   f9                   | inc                 ecx
            //   f8                   | inc                 ch
            //   4151                 | stc                 
            //   41d2e1               | jb                  0x22a10
            //   311c24               | leave               
            //   4532cd               | xchg                eax, edx
            //   4522ce               | xchg                eax, ecx

        $sequence_6 = { ff15???????? 3ac3 e9???????? 0f8492010000 440fb7442430 488b542438 490fb7c9 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   3ac3                 | stc                 
            //   e9????????           |                     
            //   0f8492010000         | inc                 ecx
            //   440fb7442430         | cmp                 dh, 0xb3
            //   488b542438           | dec                 eax
            //   490fb7c9             | mov                 dword ptr [esp + 0x18], esi

        $sequence_7 = { 8d56d4 fa 158935079e 9e 4657 250543b1d9 f661fd }
            // n = 7, score = 100
            //   8d56d4               | dec                 eax
            //   fa                   | add                 esp, 0x20
            //   158935079e           | inc                 bp
            //   9e                   | xchg                ebp, ebp
            //   4657                 | inc                 bp
            //   250543b1d9           | movsx               edi, al
            //   f661fd               | mov                 eax, ebx

        $sequence_8 = { 440fb7c1 4080fca3 6683f819 e9???????? 0f8703000000 4503c5 0fb703 }
            // n = 7, score = 100
            //   440fb7c1             | cmovne              edx, ebx
            //   4080fca3             | inc                 ecx
            //   6683f819             | mov                 edi, ebp
            //   e9????????           |                     
            //   0f8703000000         | inc                 eax
            //   4503c5               | ror                 ch, cl
            //   0fb703               | inc                 eax

        $sequence_9 = { 4180fd52 4983c004 3bc8 e9???????? 0f860a000000 b801000000 e9???????? }
            // n = 7, score = 100
            //   4180fd52             | jne                 0x1035
            //   4983c004             | mov                 edi, dword ptr [ebx]
            //   3bc8                 | dec                 edx
            //   e9????????           |                     
            //   0f860a000000         | lea                 ecx, [ecx]
            //   b801000000           | inc                 ebp
            //   e9????????           |                     

    condition:
        7 of them and filesize < 3761152
}