rule win_pcshare_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pcshare."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pcshare"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 803c3800 75db 8b16 33c0 8a0c3a 5f 84c9 }
            // n = 7, score = 100
            //   803c3800             | cmp                 byte ptr [eax + edi], 0
            //   75db                 | jne                 0xffffffdd
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   33c0                 | xor                 eax, eax
            //   8a0c3a               | mov                 cl, byte ptr [edx + edi]
            //   5f                   | pop                 edi
            //   84c9                 | test                cl, cl

        $sequence_1 = { 8db60c2c0610 6a00 50 ff36 e8???????? }
            // n = 5, score = 100
            //   8db60c2c0610         | lea                 esi, [esi + 0x10062c0c]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     

        $sequence_2 = { 8b442450 3bc3 7425 33f6 8b0c06 }
            // n = 5, score = 100
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]
            //   3bc3                 | cmp                 eax, ebx
            //   7425                 | je                  0x27
            //   33f6                 | xor                 esi, esi
            //   8b0c06               | mov                 ecx, dword ptr [esi + eax]

        $sequence_3 = { 81e20000ffff c7401400000000 0bca 89480c 8b4c2440 8b542438 }
            // n = 6, score = 100
            //   81e20000ffff         | and                 edx, 0xffff0000
            //   c7401400000000       | mov                 dword ptr [eax + 0x14], 0
            //   0bca                 | or                  ecx, edx
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]

        $sequence_4 = { 8b4c242c 85c9 7510 3b5c2430 746b 43 }
            // n = 6, score = 100
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   85c9                 | test                ecx, ecx
            //   7510                 | jne                 0x12
            //   3b5c2430             | cmp                 ebx, dword ptr [esp + 0x30]
            //   746b                 | je                  0x6d
            //   43                   | inc                 ebx

        $sequence_5 = { 8b01 03f8 8b5640 8b6e24 52 51 8bcc }
            // n = 7, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   03f8                 | add                 edi, eax
            //   8b5640               | mov                 edx, dword ptr [esi + 0x40]
            //   8b6e24               | mov                 ebp, dword ptr [esi + 0x24]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp

        $sequence_6 = { 8b5b04 03d8 c60300 8b442428 50 }
            // n = 5, score = 100
            //   8b5b04               | mov                 ebx, dword ptr [ebx + 4]
            //   03d8                 | add                 ebx, eax
            //   c60300               | mov                 byte ptr [ebx], 0
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   50                   | push                eax

        $sequence_7 = { 8d0480 8d0c80 8d048a 3d35c83301 0f8cea000000 68???????? }
            // n = 6, score = 100
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   8d0c80               | lea                 ecx, [eax + eax*4]
            //   8d048a               | lea                 eax, [edx + ecx*4]
            //   3d35c83301           | cmp                 eax, 0x133c835
            //   0f8cea000000         | jl                  0xf0
            //   68????????           |                     

        $sequence_8 = { 8b16 8d441a02 50 55 ff15???????? 85c0 890437 }
            // n = 7, score = 100
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8d441a02             | lea                 eax, [edx + ebx + 2]
            //   50                   | push                eax
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   890437               | mov                 dword ptr [edi + esi], eax

        $sequence_9 = { 8b4548 8b4c241c 8b1408 8b442420 8b4c020c 8d44020c }
            // n = 6, score = 100
            //   8b4548               | mov                 eax, dword ptr [ebp + 0x48]
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   8b1408               | mov                 edx, dword ptr [eax + ecx]
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   8b4c020c             | mov                 ecx, dword ptr [edx + eax + 0xc]
            //   8d44020c             | lea                 eax, [edx + eax + 0xc]

    condition:
        7 of them and filesize < 893708
}