rule win_pebbledash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pebbledash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pebbledash"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 b9???????? e8???????? 85c0 7514 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16

        $sequence_1 = { 5e c3 55 8b6c2408 56 33f6 8b4d00 }
            // n = 7, score = 500
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8b6c2408             | mov                 ebp, dword ptr [esp + 8]
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   8b4d00               | mov                 ecx, dword ptr [ebp]

        $sequence_2 = { e8???????? 6888130000 ff15???????? b9???????? e8???????? 68???????? e8???????? }
            // n = 7, score = 500
            //   e8????????           |                     
            //   6888130000           | push                0x1388
            //   ff15????????         |                     
            //   b9????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 832000 a1???????? a3???????? c3 8b442404 a3???????? }
            // n = 6, score = 500
            //   832000               | and                 dword ptr [eax], 0
            //   a1????????           |                     
            //   a3????????           |                     
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   a3????????           |                     

        $sequence_4 = { 5b 5e 5f c9 c3 6a01 ff742408 }
            // n = 7, score = 500
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   6a01                 | push                1
            //   ff742408             | push                dword ptr [esp + 8]

        $sequence_5 = { e8???????? 33d2 b90e000000 f7f1 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   b90e000000           | mov                 ecx, 0xe
            //   f7f1                 | div                 ecx

        $sequence_6 = { 6829080000 68???????? 68???????? e8???????? }
            // n = 4, score = 500
            //   6829080000           | push                0x829
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_7 = { 5e c3 55 8bec 833d????????00 750f }
            // n = 6, score = 500
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   833d????????00       |                     
            //   750f                 | jne                 0x11

        $sequence_8 = { 41894e04 0fb64209 0fb64a08 c1e108 0bc8 0fb6420a c1e108 }
            // n = 7, score = 200
            //   41894e04             | dec                 esp
            //   0fb64209             | mov                 dword ptr [esp + 0x20], ecx
            //   0fb64a08             | push                edi
            //   c1e108               | dec                 eax
            //   0bc8                 | sub                 esp, 0x20
            //   0fb6420a             | inc                 ecx
            //   c1e108               | add                 ebx, 8

        $sequence_9 = { 4c8bf1 488bf1 85c0 bd01000000 0f44c5 41c1e008 8905???????? }
            // n = 7, score = 200
            //   4c8bf1               | mov                 dword ptr [esi + 8], ecx
            //   488bf1               | movzx               eax, byte ptr [edx + 0xd]
            //   85c0                 | movzx               ecx, byte ptr [edx + 0xc]
            //   bd01000000           | shl                 ecx, 8
            //   0f44c5               | or                  ecx, eax
            //   41c1e008             | movzx               eax, byte ptr [edx + 1]
            //   8905????????         |                     

        $sequence_10 = { c1e108 0bc8 0fb6420b c1e108 0bc8 41894e08 0fb6420d }
            // n = 7, score = 200
            //   c1e108               | punpckldq           xmm2, xmm1
            //   0bc8                 | movd                xmm0, dword ptr [ebx + edx*8 + 0x10]
            //   0fb6420b             | inc                 dx
            //   c1e108               | movd                mm1, dword ptr [ebx + ecx*8 + 0x10]
            //   0bc8                 | dec                 ebx
            //   41894e08             | lea                 ecx, [ebx + ebx*2]
            //   0fb6420d             | movd                xmm3, dword ptr [ebx + ecx*8 + 0x10]

        $sequence_11 = { 0fb64201 4c8db100010000 0fb63a 4c8d258fdaffff 440fb65a04 4d8be8 440fb64a08 }
            // n = 7, score = 200
            //   0fb64201             | mov                 ebp, eax
            //   4c8db100010000       | inc                 esp
            //   0fb63a               | movzx               ecx, byte ptr [edx + 8]
            //   4c8d258fdaffff       | dec                 esp
            //   440fb65a04           | mov                 esi, ecx
            //   4d8be8               | movzx               eax, byte ptr [edx + 0xa]
            //   440fb64a08           | shl                 ecx, 8

        $sequence_12 = { 66420f6e4ccb10 4b8d0c5b 660f6e5ccb10 4183c308 4c8d0440 66420f6e54c310 8d47ff }
            // n = 7, score = 200
            //   66420f6e4ccb10       | mov                 ecx, esp
            //   4b8d0c5b             | dec                 eax
            //   660f6e5ccb10         | mov                 esi, ecx
            //   4183c308             | test                eax, eax
            //   4c8d0440             | mov                 ebp, 1
            //   66420f6e54c310       | cmove               eax, ebp
            //   8d47ff               | inc                 ecx

        $sequence_13 = { 41c1e008 8905???????? 0fb64201 440bc0 0fb64202 41c1e008 }
            // n = 6, score = 200
            //   41c1e008             | or                  ecx, eax
            //   8905????????         |                     
            //   0fb64201             | movzx               eax, byte ptr [edx + 0xf]
            //   440bc0               | shl                 ecx, 8
            //   0fb64202             | or                  ecx, eax
            //   41c1e008             | inc                 ecx

        $sequence_14 = { 415e 415d 415c 5d c3 498bcc e8???????? }
            // n = 7, score = 200
            //   415e                 | movd                mm2, dword ptr [ebx + eax*8 + 0x10]
            //   415d                 | lea                 eax, [edi - 1]
            //   415c                 | dec                 eax
            //   5d                   | lea                 edx, [eax + eax*2]
            //   c3                   | punpckldq           xmm2, xmm1
            //   498bcc               | dec                 esp
            //   e8????????           |                     

        $sequence_15 = { e8???????? 488b0d???????? 33d2 ffd0 85c0 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   33d2                 | movzx               eax, byte ptr [edx + 1]
            //   ffd0                 | inc                 esp
            //   85c0                 | or                  eax, eax

    condition:
        7 of them and filesize < 677888
}