rule win_penco_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.penco."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.penco"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33349500d83400 8bcf c1e918 33348d28ec3400 8b4c2410 0fb6d1 33349500d43400 }
            // n = 7, score = 100
            //   33349500d83400       | xor                 esi, dword ptr [edx*4 + 0x34d800]
            //   8bcf                 | mov                 ecx, edi
            //   c1e918               | shr                 ecx, 0x18
            //   33348d28ec3400       | xor                 esi, dword ptr [ecx*4 + 0x34ec28]
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   0fb6d1               | movzx               edx, cl
            //   33349500d43400       | xor                 esi, dword ptr [edx*4 + 0x34d400]

        $sequence_1 = { 75f6 8b542410 52 ff15???????? 6800c00000 6a00 56 }
            // n = 7, score = 100
            //   75f6                 | jne                 0xfffffff8
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   6800c00000           | push                0xc000
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_2 = { 51 8d95ecf0ffff 52 8b85b0fdffff 8d8c05e0fdffff 51 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   8d95ecf0ffff         | lea                 edx, [ebp - 0xf14]
            //   52                   | push                edx
            //   8b85b0fdffff         | mov                 eax, dword ptr [ebp - 0x250]
            //   8d8c05e0fdffff       | lea                 ecx, [ebp + eax - 0x220]
            //   51                   | push                ecx

        $sequence_3 = { 6800300000 8b9548feffff 52 6a00 ff15???????? 8945e4 }
            // n = 6, score = 100
            //   6800300000           | push                0x3000
            //   8b9548feffff         | mov                 edx, dword ptr [ebp - 0x1b8]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax

        $sequence_4 = { ff15???????? 68???????? 8b4de4 51 ff15???????? 6a02 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   68????????           |                     
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   6a02                 | push                2

        $sequence_5 = { 8d8c245c020000 51 03f0 8d142e 68???????? 52 e8???????? }
            // n = 7, score = 100
            //   8d8c245c020000       | lea                 ecx, [esp + 0x25c]
            //   51                   | push                ecx
            //   03f0                 | add                 esi, eax
            //   8d142e               | lea                 edx, [esi + ebp]
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_6 = { 69c0c4020000 c784059c96ffff4d000000 e9???????? c7851c94ffff00000000 b901000000 85c9 0f8409090000 }
            // n = 7, score = 100
            //   69c0c4020000         | imul                eax, eax, 0x2c4
            //   c784059c96ffff4d000000     | mov    dword ptr [ebp + eax - 0x6964], 0x4d
            //   e9????????           |                     
            //   c7851c94ffff00000000     | mov    dword ptr [ebp - 0x6be4], 0
            //   b901000000           | mov                 ecx, 1
            //   85c9                 | test                ecx, ecx
            //   0f8409090000         | je                  0x90f

        $sequence_7 = { 8b4508 56 8d34c5c0c23400 833e00 7513 50 e8???????? }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   8d34c5c0c23400       | lea                 esi, [eax*8 + 0x34c2c0]
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7513                 | jne                 0x15
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 3bc6 740b 3dea000000 0f85d8000000 8b6c2410 3bee 0f84da000000 }
            // n = 7, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   740b                 | je                  0xd
            //   3dea000000           | cmp                 eax, 0xea
            //   0f85d8000000         | jne                 0xde
            //   8b6c2410             | mov                 ebp, dword ptr [esp + 0x10]
            //   3bee                 | cmp                 ebp, esi
            //   0f84da000000         | je                  0xe0

        $sequence_9 = { 8b349528ec3400 8b542414 894c241c 8b4c2410 c1e910 0fb6f9 3334bd28e83400 }
            // n = 7, score = 100
            //   8b349528ec3400       | mov                 esi, dword ptr [edx*4 + 0x34ec28]
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   c1e910               | shr                 ecx, 0x10
            //   0fb6f9               | movzx               edi, cl
            //   3334bd28e83400       | xor                 esi, dword ptr [edi*4 + 0x34e828]

    condition:
        7 of them and filesize < 319488
}