rule win_petrwrap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.petrwrap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.petrwrap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b442458 8bf9 0fa4c119 33f2 c1e019 }
            // n = 5, score = 100
            //   8b442458             | mov                 eax, dword ptr [esp + 0x58]
            //   8bf9                 | mov                 edi, ecx
            //   0fa4c119             | shld                ecx, eax, 0x19
            //   33f2                 | xor                 esi, edx
            //   c1e019               | shl                 eax, 0x19

        $sequence_1 = { 894c241c 3bcf 763b 6845030000 68???????? 6a44 6a68 }
            // n = 7, score = 100
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx
            //   3bcf                 | cmp                 ecx, edi
            //   763b                 | jbe                 0x3d
            //   6845030000           | push                0x345
            //   68????????           |                     
            //   6a44                 | push                0x44
            //   6a68                 | push                0x68

        $sequence_2 = { 68???????? 57 e8???????? 83c408 85c0 0f89ff010000 57 }
            // n = 7, score = 100
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f89ff010000         | jns                 0x205
            //   57                   | push                edi

        $sequence_3 = { 3bd9 7301 47 8b442414 89700c 8b4508 33f6 }
            // n = 7, score = 100
            //   3bd9                 | cmp                 ebx, ecx
            //   7301                 | jae                 3
            //   47                   | inc                 edi
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   89700c               | mov                 dword ptr [eax + 0xc], esi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   33f6                 | xor                 esi, esi

        $sequence_4 = { 50 e8???????? 83c410 ff15???????? 8945b4 b808000000 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   ff15????????         |                     
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   b808000000           | mov                 eax, 8
            //   e8????????           |                     

        $sequence_5 = { 83c430 83c20a 89542444 85d2 }
            // n = 4, score = 100
            //   83c430               | add                 esp, 0x30
            //   83c20a               | add                 edx, 0xa
            //   89542444             | mov                 dword ptr [esp + 0x44], edx
            //   85d2                 | test                edx, edx

        $sequence_6 = { 330c85d01c4400 8b44242c c1e818 330c85d0184400 0fb6c2 330c85d0244400 8bc3 }
            // n = 7, score = 100
            //   330c85d01c4400       | xor                 ecx, dword ptr [eax*4 + 0x441cd0]
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   c1e818               | shr                 eax, 0x18
            //   330c85d0184400       | xor                 ecx, dword ptr [eax*4 + 0x4418d0]
            //   0fb6c2               | movzx               eax, dl
            //   330c85d0244400       | xor                 ecx, dword ptr [eax*4 + 0x4424d0]
            //   8bc3                 | mov                 eax, ebx

        $sequence_7 = { 8b4c2440 83c42c 894c241c 85c0 7507 6831020000 eb44 }
            // n = 7, score = 100
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   83c42c               | add                 esp, 0x2c
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   6831020000           | push                0x231
            //   eb44                 | jmp                 0x46

        $sequence_8 = { 8b4d00 89450c 8b03 894c2424 8d04b0 2bf2 c1fe1f }
            // n = 7, score = 100
            //   8b4d00               | mov                 ecx, dword ptr [ebp]
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx
            //   8d04b0               | lea                 eax, [eax + esi*4]
            //   2bf2                 | sub                 esi, edx
            //   c1fe1f               | sar                 esi, 0x1f

        $sequence_9 = { 4a 75f5 8b0e c7460406000000 83c114 8d4900 8b01 }
            // n = 7, score = 100
            //   4a                   | dec                 edx
            //   75f5                 | jne                 0xfffffff7
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   c7460406000000       | mov                 dword ptr [esi + 4], 6
            //   83c114               | add                 ecx, 0x14
            //   8d4900               | lea                 ecx, [ecx]
            //   8b01                 | mov                 eax, dword ptr [ecx]

    condition:
        7 of them and filesize < 1024000
}