rule win_petya_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.petya."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.petya"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc7 c1e810 88442431 8bc7 c1e808 88442432 }
            // n = 6, score = 600
            //   8bc7                 | mov                 eax, edi
            //   c1e810               | shr                 eax, 0x10
            //   88442431             | mov                 byte ptr [esp + 0x31], al
            //   8bc7                 | mov                 eax, edi
            //   c1e808               | shr                 eax, 8
            //   88442432             | mov                 byte ptr [esp + 0x32], al

        $sequence_1 = { 117c2434 33f6 0facc81c c1e204 0bf0 c1e91c }
            // n = 6, score = 600
            //   117c2434             | adc                 dword ptr [esp + 0x34], edi
            //   33f6                 | xor                 esi, esi
            //   0facc81c             | shrd                eax, ecx, 0x1c
            //   c1e204               | shl                 edx, 4
            //   0bf0                 | or                  esi, eax
            //   c1e91c               | shr                 ecx, 0x1c

        $sequence_2 = { 56 8b35???????? 33c9 57 33ff 8d0486 8bd8 }
            // n = 7, score = 600
            //   56                   | push                esi
            //   8b35????????         |                     
            //   33c9                 | xor                 ecx, ecx
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   8d0486               | lea                 eax, [esi + eax*4]
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { 83c604 3bfb 72f0 5f 5e 5b }
            // n = 6, score = 600
            //   83c604               | add                 esi, 4
            //   3bfb                 | cmp                 edi, ebx
            //   72f0                 | jb                  0xfffffff2
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_4 = { 0bf1 33442424 33fe 23442420 }
            // n = 4, score = 600
            //   0bf1                 | or                  esi, ecx
            //   33442424             | xor                 eax, dword ptr [esp + 0x24]
            //   33fe                 | xor                 edi, esi
            //   23442420             | and                 eax, dword ptr [esp + 0x20]

        $sequence_5 = { 8b4c2420 33fe 8bf0 33da 0facc80e 33d2 c1e612 }
            // n = 7, score = 600
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   33fe                 | xor                 edi, esi
            //   8bf0                 | mov                 esi, eax
            //   33da                 | xor                 ebx, edx
            //   0facc80e             | shrd                eax, ecx, 0xe
            //   33d2                 | xor                 edx, edx
            //   c1e612               | shl                 esi, 0x12

        $sequence_6 = { 8bca 88442428 8bc6 c1e810 88442429 8bc6 }
            // n = 6, score = 600
            //   8bca                 | mov                 ecx, edx
            //   88442428             | mov                 byte ptr [esp + 0x28], al
            //   8bc6                 | mov                 eax, esi
            //   c1e810               | shr                 eax, 0x10
            //   88442429             | mov                 byte ptr [esp + 0x29], al
            //   8bc6                 | mov                 eax, esi

        $sequence_7 = { 56 8b750c 57 83fe01 7517 }
            // n = 5, score = 600
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   83fe01               | cmp                 esi, 1
            //   7517                 | jne                 0x19

        $sequence_8 = { 8bca c1e303 0facc110 897c2424 c1e810 8bc2 884c242d }
            // n = 7, score = 600
            //   8bca                 | mov                 ecx, edx
            //   c1e303               | shl                 ebx, 3
            //   0facc110             | shrd                ecx, eax, 0x10
            //   897c2424             | mov                 dword ptr [esp + 0x24], edi
            //   c1e810               | shr                 eax, 0x10
            //   8bc2                 | mov                 eax, edx
            //   884c242d             | mov                 byte ptr [esp + 0x2d], cl

        $sequence_9 = { 8b5d0c 33c9 56 8b7508 2bde }
            // n = 5, score = 600
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   33c9                 | xor                 ecx, ecx
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   2bde                 | sub                 ebx, esi

    condition:
        7 of them and filesize < 229376
}