rule win_phantomcore_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.phantomcore."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phantomcore"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45d0 8d4da8 68???????? 50 e8???????? c745f001000000 8d45c0 }
            // n = 7, score = 100
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   8d45c0               | lea                 eax, [ebp - 0x40]

        $sequence_1 = { e9???????? 8b16 0f57c0 0f1145c8 83f803 bf03000000 0f42f8 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   0f57c0               | xorps               xmm0, xmm0
            //   0f1145c8             | movups              xmmword ptr [ebp - 0x38], xmm0
            //   83f803               | cmp                 eax, 3
            //   bf03000000           | mov                 edi, 3
            //   0f42f8               | cmovb               edi, eax

        $sequence_2 = { 8b65e8 83c50c c745f0ffffffff ff75d8 ff15???????? ff75d8 ff15???????? }
            // n = 7, score = 100
            //   8b65e8               | mov                 esp, dword ptr [ebp - 0x18]
            //   83c50c               | add                 ebp, 0xc
            //   c745f0ffffffff       | mov                 dword ptr [ebp - 0x10], 0xffffffff
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   ff15????????         |                     
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   ff15????????         |                     

        $sequence_3 = { c78634020000cc734b00 c7864402000018714b00 8d8648020000 50 e8???????? 83c404 c7863402000018714b00 }
            // n = 7, score = 100
            //   c78634020000cc734b00     | mov    dword ptr [esi + 0x234], 0x4b73cc
            //   c7864402000018714b00     | mov    dword ptr [esi + 0x244], 0x4b7118
            //   8d8648020000         | lea                 eax, [esi + 0x248]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c7863402000018714b00     | mov    dword ptr [esi + 0x234], 0x4b7118

        $sequence_4 = { eb11 8975d8 50 e8???????? 83c404 89c1 8b45d8 }
            // n = 7, score = 100
            //   eb11                 | jmp                 0x13
            //   8975d8               | mov                 dword ptr [ebp - 0x28], esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89c1                 | mov                 ecx, eax
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]

        $sequence_5 = { c745c818714b00 8d4dcc c745d000000000 c745cc00000000 c745c026f64b00 c645c401 8d45c0 }
            // n = 7, score = 100
            //   c745c818714b00       | mov                 dword ptr [ebp - 0x38], 0x4b7118
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   c745c026f64b00       | mov                 dword ptr [ebp - 0x40], 0x4bf626
            //   c645c401             | mov                 byte ptr [ebp - 0x3c], 1
            //   8d45c0               | lea                 eax, [ebp - 0x40]

        $sequence_6 = { c7443a480f000000 c6443a3400 8d1c3a 83c34c 83c74c 39cb 0f8571ffffff }
            // n = 7, score = 100
            //   c7443a480f000000     | mov                 dword ptr [edx + edi + 0x48], 0xf
            //   c6443a3400           | mov                 byte ptr [edx + edi + 0x34], 0
            //   8d1c3a               | lea                 ebx, [edx + edi]
            //   83c34c               | add                 ebx, 0x4c
            //   83c74c               | add                 edi, 0x4c
            //   39cb                 | cmp                 ebx, ecx
            //   0f8571ffffff         | jne                 0xffffff77

        $sequence_7 = { e8???????? 83c410 68???????? 8d852cffffff 50 e8???????? 83c408 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   68????????           |                     
            //   8d852cffffff         | lea                 eax, [ebp - 0xd4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_8 = { ff431c c7431800000000 c74344e1c94b00 b80e000000 e9???????? c745f0ffffffff 0fb64dac }
            // n = 7, score = 100
            //   ff431c               | inc                 dword ptr [ebx + 0x1c]
            //   c7431800000000       | mov                 dword ptr [ebx + 0x18], 0
            //   c74344e1c94b00       | mov                 dword ptr [ebx + 0x44], 0x4bc9e1
            //   b80e000000           | mov                 eax, 0xe
            //   e9????????           |                     
            //   c745f0ffffffff       | mov                 dword ptr [ebp - 0x10], 0xffffffff
            //   0fb64dac             | movzx               ecx, byte ptr [ebp - 0x54]

        $sequence_9 = { ff7514 ff74240c 6a01 57 e8???????? 8b0e 8b01 }
            // n = 7, score = 100
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   6a01                 | push                1
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b01                 | mov                 eax, dword ptr [ecx]

    condition:
        7 of them and filesize < 1840128
}