rule win_phorpiex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.phorpiex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phorpiex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 ff15???????? ff15???????? 50 e8???????? }
            // n = 5, score = 1100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { ff15???????? 85c0 740f 6a07 }
            // n = 4, score = 1100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   6a07                 | push                7

        $sequence_2 = { ff15???????? 85c0 741f 6880000000 }
            // n = 4, score = 1000
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   741f                 | je                  0x21
            //   6880000000           | push                0x80

        $sequence_3 = { 6a00 6a20 6a00 6a00 6a00 8b5508 }
            // n = 6, score = 900
            //   6a00                 | push                0
            //   6a20                 | push                0x20
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_4 = { e8???????? 83c410 6a00 6a02 6a02 6a00 }
            // n = 6, score = 900
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   6a02                 | push                2
            //   6a00                 | push                0

        $sequence_5 = { 6a01 6a00 68???????? e8???????? 83c40c 33c0 }
            // n = 6, score = 800
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { e8???????? 99 b90d000000 f7f9 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b90d000000           | mov                 ecx, 0xd
            //   f7f9                 | idiv                ecx

        $sequence_7 = { 50 e8???????? 83c404 e8???????? e8???????? ff15???????? }
            // n = 6, score = 800
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e8????????           |                     
            //   e8????????           |                     
            //   ff15????????         |                     

        $sequence_8 = { 68???????? ff15???????? 8d85f8fdffff 50 68???????? }
            // n = 5, score = 700
            //   68????????           |                     
            //   ff15????????         |                     
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_9 = { 6a00 ff15???????? 85c0 7418 ff15???????? }
            // n = 5, score = 700
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   ff15????????         |                     

        $sequence_10 = { 6a01 ff15???????? ff15???????? b001 }
            // n = 4, score = 700
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   b001                 | mov                 al, 1

        $sequence_11 = { 6a00 682a800000 6a00 ff15???????? }
            // n = 4, score = 700
            //   6a00                 | push                0
            //   682a800000           | push                0x802a
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_12 = { 52 683f000f00 6a00 68???????? 6802000080 ff15???????? 85c0 }
            // n = 7, score = 700
            //   52                   | push                edx
            //   683f000f00           | push                0xf003f
            //   6a00                 | push                0
            //   68????????           |                     
            //   6802000080           | push                0x80000002
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_13 = { 7416 8b4df8 51 ff15???????? 8b55fc 52 e8???????? }
            // n = 7, score = 600
            //   7416                 | je                  0x18
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_14 = { f7f9 81c210270000 52 e8???????? }
            // n = 4, score = 600
            //   f7f9                 | idiv                ecx
            //   81c210270000         | add                 edx, 0x2710
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_15 = { 85c0 752b 8b8510ffffff 83c001 }
            // n = 4, score = 600
            //   85c0                 | test                eax, eax
            //   752b                 | jne                 0x2d
            //   8b8510ffffff         | mov                 eax, dword ptr [ebp - 0xf0]
            //   83c001               | add                 eax, 1

        $sequence_16 = { 6a01 ff15???????? 8945f8 837df800 7429 8b45f8 }
            // n = 6, score = 600
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7429                 | je                  0x2b
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_17 = { 68???????? ff15???????? e9???????? 8d45fc }
            // n = 4, score = 600
            //   68????????           |                     
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_18 = { 50 e8???????? 59 59 85c0 7573 }
            // n = 6, score = 500
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7573                 | jne                 0x75

        $sequence_19 = { 3d00010000 7504 83c8ff c3 }
            // n = 4, score = 500
            //   3d00010000           | cmp                 eax, 0x100
            //   7504                 | jne                 6
            //   83c8ff               | or                  eax, 0xffffffff
            //   c3                   | ret                 

        $sequence_20 = { 7508 6a00 ff15???????? 6804010000 }
            // n = 4, score = 500
            //   7508                 | jne                 0xa
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6804010000           | push                0x104

        $sequence_21 = { 6a21 50 e8???????? c60000 }
            // n = 4, score = 500
            //   6a21                 | push                0x21
            //   50                   | push                eax
            //   e8????????           |                     
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_22 = { 52 e8???????? 99 b960ea0000 f7f9 }
            // n = 5, score = 400
            //   52                   | push                edx
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b960ea0000           | mov                 ecx, 0xea60
            //   f7f9                 | idiv                ecx

        $sequence_23 = { 56 ff15???????? b001 5e 81c408020000 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   ff15????????         |                     
            //   b001                 | mov                 al, 1
            //   5e                   | pop                 esi
            //   81c408020000         | add                 esp, 0x208

        $sequence_24 = { 68???????? 8d942410010000 6804010000 52 e8???????? }
            // n = 5, score = 400
            //   68????????           |                     
            //   8d942410010000       | lea                 edx, [esp + 0x110]
            //   6804010000           | push                0x104
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_25 = { 40 84c9 75f9 8b0cb3 2bc2 50 }
            // n = 6, score = 400
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   8b0cb3               | mov                 ecx, dword ptr [ebx + esi*4]
            //   2bc2                 | sub                 eax, edx
            //   50                   | push                eax

        $sequence_26 = { 41 663bc2 72f7 53 33c0 }
            // n = 5, score = 300
            //   41                   | inc                 ecx
            //   663bc2               | cmp                 ax, dx
            //   72f7                 | jb                  0xfffffff9
            //   53                   | push                ebx
            //   33c0                 | xor                 eax, eax

        $sequence_27 = { 56 57 68e8030000 ff15???????? e8???????? be???????? }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     
            //   e8????????           |                     
            //   be????????           |                     

        $sequence_28 = { 50 8d45ec 50 6805000020 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   6805000020           | push                0x20000005

        $sequence_29 = { 8d45f8 50 8d45e4 50 6805000020 }
            // n = 5, score = 200
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   6805000020           | push                0x20000005

    condition:
        7 of them and filesize < 2490368
}